/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.data.recipes.FoodValueRecipe;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.IFoodInfo;
import com.teammoeg.caupona.util.SpicedFoodInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SauteedFoodInfo
extends SpicedFoodInfo
implements IFoodInfo {
    public List<FloatemStack> stacks;
    public List<Pair<MobEffectInstance, Float>> foodeffect = new ArrayList<Pair<MobEffectInstance, Float>>();
    public int healing;
    public float saturation;

    public SauteedFoodInfo(List<FloatemStack> stacks, int healing, float saturation) {
        this.stacks = stacks;
        this.healing = healing;
        this.saturation = saturation;
    }

    public SauteedFoodInfo() {
        this(new ArrayList<FloatemStack>(), 0, 0.0f);
    }

    public static List<FloatemStack> getStacks(CompoundTag nbt) {
        return nbt.m_128437_("items", 10).stream().map(e -> (CompoundTag)e).map(FloatemStack::new).collect(Collectors.toList());
    }

    public SauteedFoodInfo(CompoundTag nbt) {
        super(nbt);
        this.stacks = nbt.m_128437_("items", 10).stream().map(e -> (CompoundTag)e).map(FloatemStack::new).collect(Collectors.toList());
        this.healing = nbt.m_128451_("heal");
        this.saturation = nbt.m_128457_("sat");
        this.foodeffect = nbt.m_128437_("feffects", 10).stream().map(e -> (CompoundTag)e).map(e -> new Pair((Object)MobEffectInstance.m_19560_((CompoundTag)e.m_128469_("effect")), (Object)Float.valueOf(e.m_128457_("chance")))).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public void completeAll() {
        this.completeData();
    }

    public void completeData() {
        this.stacks.sort(Comparator.comparingInt(e -> Item.m_41393_((Item)e.stack.m_41720_())));
        this.foodeffect.sort(Comparator.comparingInt(e -> MobEffect.m_19459_((MobEffect)((MobEffectInstance)e.getFirst()).m_19544_())).thenComparing(Pair::getSecond));
    }

    public static boolean isEffectEquals(MobEffectInstance t1, MobEffectInstance t2) {
        return t1.m_19544_() == t2.m_19544_() && t1.m_19564_() == t2.m_19564_();
    }

    public void recalculateHAS() {
        this.foodeffect.clear();
        float nh = 0.0f;
        float ns = 0.0f;
        for (FloatemStack fs : this.stacks) {
            FoodValueRecipe fvr = FoodValueRecipe.recipes.get(fs.getItem());
            if (fvr != null) {
                nh += (float)fvr.heal * fs.count;
                ns += fvr.sat * fs.count * (float)fvr.heal;
                if (fvr.effects == null) continue;
                this.foodeffect.addAll(fvr.effects);
                continue;
            }
            FoodProperties f = fs.getStack().getFoodProperties(null);
            if (f == null) continue;
            nh += fs.count * (float)f.m_38744_();
            ns += fs.count * f.m_38745_() * (float)f.m_38744_();
            this.foodeffect.addAll(f.m_38749_());
        }
        int conv = (int)(0.075 * (double)nh);
        this.healing = (int)Math.ceil(nh - (float)conv);
        this.saturation = this.healing > 0 ? Math.max(0.6f, (ns += (float)conv / 2.0f) / (float)this.healing) : 0.0f;
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        this.write(nbt);
        return nbt;
    }

    public void setParts(int parts) {
        for (FloatemStack i : this.stacks) {
            i.count /= (float)parts;
        }
    }

    public void addItem(ItemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is)) continue;
            i.count += (float)is.m_41613_();
            return;
        }
        this.stacks.add(new FloatemStack(is.m_41777_(), is.m_41613_()));
    }

    public void addItem(FloatemStack is) {
        for (FloatemStack i : this.stacks) {
            if (!i.equals(is.getStack())) continue;
            i.count += is.count;
            return;
        }
        this.stacks.add(is);
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        nbt.m_128365_("items", (Tag)SerializeUtil.toNBTList(this.stacks, FloatemStack::serializeNBT));
        nbt.m_128365_("feffects", (Tag)SerializeUtil.toNBTList(this.foodeffect, e -> {
            CompoundTag cnbt = new CompoundTag();
            cnbt.m_128365_("effect", (Tag)((MobEffectInstance)e.getFirst()).m_19555_(new CompoundTag()));
            cnbt.m_128350_("chance", ((Float)e.getSecond()).floatValue());
            return cnbt;
        }));
        nbt.m_128405_("heal", this.healing);
        nbt.m_128350_("sat", this.saturation);
    }

    @Override
    public List<FloatemStack> getStacks() {
        return this.stacks;
    }

    @Override
    public int getHealing() {
        return this.healing;
    }

    @Override
    public float getSaturation() {
        return this.saturation;
    }

    @Override
    public FoodProperties getFood() {
        FoodProperties.Builder b = new FoodProperties.Builder();
        if (this.spice != null) {
            b.effect(() -> new MobEffectInstance(this.spice), 1.0f);
        }
        for (Pair<MobEffectInstance, Float> ef : this.foodeffect) {
            b.effect(() -> new MobEffectInstance((MobEffectInstance)ef.getFirst()), ((Float)ef.getSecond()).floatValue());
        }
        b.m_38760_(this.healing);
        if (Float.isNaN(this.saturation)) {
            b.m_38758_(0.0f);
        } else {
            b.m_38758_(this.saturation);
        }
        return b.m_38767_();
    }

    @Override
    public List<Pair<Supplier<MobEffectInstance>, Float>> getEffects() {
        ArrayList<Pair> li = new ArrayList<Pair>();
        if (this.spice != null) {
            li.add(Pair.of(() -> new MobEffectInstance(this.spice), (Object)Float.valueOf(1.0f)));
        }
        for (Pair<MobEffectInstance, Float> ef : this.foodeffect) {
            li.add(Pair.of(() -> new MobEffectInstance((MobEffectInstance)ef.getFirst()), (Object)((Float)ef.getSecond())));
        }
        return null;
    }
}

