/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona;

import com.google.common.collect.ImmutableSet;
import com.teammoeg.caupona.CPItems;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.generated.CPStewTexture;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CPFluids {
    private static final ResourceLocation STILL_WATER_TEXTURE = new ResourceLocation("block/water_still");
    private static final ResourceLocation STILL_SOUP_TEXTURE = new ResourceLocation("caupona", "block/soup_fluid");
    private static final ResourceLocation STILL_MILK_TEXTURE = new ResourceLocation("forge", "block/milk_still");
    static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"caupona");
    static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"caupona");

    public static TextureColorPair soup(int c) {
        return new TextureColorPair(STILL_SOUP_TEXTURE, c);
    }

    public static TextureColorPair water(int c) {
        return new TextureColorPair(STILL_WATER_TEXTURE, c);
    }

    public static TextureColorPair milk(int c) {
        return new TextureColorPair(STILL_MILK_TEXTURE, c);
    }

    public static Stream<Fluid> getAll() {
        return Arrays.stream(CPItems.soups).map(e -> new ResourceLocation("caupona", e)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0));
    }

    public static Stream<ResourceKey<Fluid>> getAllKeys() {
        return Arrays.stream(CPItems.soups).map(e -> new ResourceLocation("caupona", e)).map(e -> ResourceKey.m_135785_((ResourceKey)Registries.f_256808_, (ResourceLocation)e));
    }

    public static Set<String> getSoupfluids() {
        return ImmutableSet.copyOf((Object[])CPItems.soups);
    }

    static {
        for (String i : CPItems.soups) {
            RegistryObject type = FLUID_TYPES.register(i, () -> new TextureColorPair(CPStewTexture.texture.getOrDefault(i, STILL_SOUP_TEXTURE), -1).create(i));
            LazySupplier crf = new LazySupplier();
            crf.setVal(FLUIDS.register(i, () -> new SoupFluid(new ForgeFlowingFluid.Properties((Supplier)type, (Supplier)crf, (Supplier)crf).slopeFindDistance(1).explosionResistance(100.0f))));
        }
    }

    private static class TextureColorPair {
        ResourceLocation texture;
        int c;

        public TextureColorPair(ResourceLocation t, int c) {
            this.texture = t;
            this.c = c;
        }

        public FluidType create(String n) {
            final ResourceLocation rt = CPStewTexture.texture.getOrDefault(n, this.texture);
            final int cx = CPStewTexture.texture.containsKey(n) ? -1 : this.c;
            FluidType ft = new FluidType(FluidType.Properties.create().viscosity(1200).temperature(333).rarity(Rarity.UNCOMMON).descriptionId("item.caupona." + n)){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public int getTintColor() {
                            return cx;
                        }

                        public ResourceLocation getStillTexture() {
                            return rt;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return rt;
                        }
                    });
                }
            };
            return ft;
        }
    }

    public static class LazySupplier<T>
    implements Supplier<T> {
        Supplier<T> val;

        @Override
        public T get() {
            if (this.val == null) {
                return null;
            }
            return this.val.get();
        }

        public void setVal(Supplier<T> val) {
            this.val = val;
        }
    }
}

