/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.foods;

import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.foods.BowlBlockEntity;
import com.teammoeg.caupona.item.StewItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class BowlBlock
extends CPRegisteredEntityBlock<BowlBlockEntity> {
    static final VoxelShape shape = Block.m_49796_((double)2.8, (double)0.0, (double)2.8, (double)13.2, (double)5.2, (double)13.2);

    public BowlBlock(BlockBehaviour.Properties blockProps, RegistryObject<BlockEntityType<BowlBlockEntity>> ste) {
        super(blockProps, ste);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = worldIn.m_7702_(pos)) instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            CPRegisteredEntityBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)bowl.internal);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult p = super.m_6227_(state, worldIn, pos, player, handIn, hit);
        if (p.m_19077_()) {
            return p;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            if (bowl.internal != null && bowl.internal.m_41720_() instanceof StewItem && bowl.internal.m_41614_()) {
                FoodProperties fp = bowl.internal.getFoodProperties((LivingEntity)player);
                if (bowl.isInfinite) {
                    if (player.m_36391_(fp.m_38747_())) {
                        player.m_5584_(worldIn, bowl.internal.m_41777_());
                        bowl.syncData();
                    }
                } else if (player.m_36391_(fp.m_38747_())) {
                    ItemStack iout = bowl.internal.getCraftingRemainingItem();
                    player.m_5584_(worldIn, bowl.internal);
                    bowl.internal = iout;
                    bowl.syncData();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            bowl.internal = ItemHandlerHelper.copyStackWithSize((ItemStack)pStack, (int)1);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            if (bowl.internal == null) {
                return ItemStack.f_41583_;
            }
            return bowl.internal.m_41777_();
        }
        return this.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof BowlBlockEntity) {
            BowlBlockEntity bowl = (BowlBlockEntity)blockEntity;
            if (bowl.internal != null && !bowl.internal.m_41619_() && bowl.internal.m_41614_()) {
                return 15;
            }
        }
        return 0;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

