/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.data.recipes.CountingTags;
import com.teammoeg.caupona.util.Utils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FoodValueRecipe
extends IDataRecipe {
    public static Map<Item, FoodValueRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public static Set<FoodValueRecipe> recipeset;
    public int heal;
    public float sat;
    public List<Pair<MobEffectInstance, Float>> effects;
    public final Map<Item, Integer> processtimes;
    private ItemStack repersent;
    public transient Set<ResourceLocation> tags;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public FoodValueRecipe(ResourceLocation id, int heal, float sat, ItemStack rps, Item ... types) {
        super(id);
        this.heal = heal;
        this.sat = sat;
        this.processtimes = new LinkedHashMap<Item, Integer>();
        this.repersent = rps;
        for (Item i : types) {
            this.processtimes.put(i, 0);
        }
    }

    public FoodValueRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        ItemStack[] i;
        this.heal = jo.get("heal").getAsInt();
        this.sat = jo.get("sat").getAsFloat();
        this.processtimes = SerializeUtil.parseJsonList(jo.get("items"), x -> {
            ResourceLocation rl = new ResourceLocation(x.get("item").getAsString());
            if (ForgeRegistries.ITEMS.containsKey(rl)) {
                Item i = (Item)ForgeRegistries.ITEMS.getValue(rl);
                int f = 0;
                if (x.has("time")) {
                    f = x.get("time").getAsInt();
                }
                if (i == Items.f_41852_) {
                    return null;
                }
                return new Pair((Object)i, (Object)f);
            }
            return null;
        }).stream().filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        if (this.processtimes.isEmpty()) {
            throw new InvalidRecipeException();
        }
        this.effects = SerializeUtil.parseJsonList(jo.get("effects"), x -> {
            ResourceLocation rl = new ResourceLocation(x.get("effect").getAsString());
            if (ForgeRegistries.POTIONS.containsKey(rl)) {
                MobEffect eff;
                int amplifier = 0;
                if (x.has("level")) {
                    amplifier = x.get("level").getAsInt();
                }
                int duration = 0;
                if (x.has("time")) {
                    duration = x.get("time").getAsInt();
                }
                if ((eff = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(rl)) == null) {
                    return null;
                }
                MobEffectInstance effect = new MobEffectInstance(eff, duration, amplifier);
                float f = 1.0f;
                if (x.has("chance")) {
                    f = x.get("chance").getAsInt();
                }
                return new Pair((Object)effect, (Object)Float.valueOf(f));
            }
            return null;
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (this.effects != null) {
            this.effects.removeIf(e -> e == null);
        }
        if (jo.has("item") && (i = Ingredient.m_43917_((JsonElement)jo.get("item")).m_43908_()).length > 0) {
            this.repersent = i[0];
        }
    }

    @Override
    public void serializeRecipeData(JsonObject json) {
        json.addProperty("heal", (Number)this.heal);
        json.addProperty("sat", (Number)Float.valueOf(this.sat));
        if (this.processtimes != null && !this.processtimes.isEmpty()) {
            json.add("items", (JsonElement)SerializeUtil.toJsonList(this.processtimes.entrySet(), e -> {
                JsonObject jo = new JsonObject();
                jo.addProperty("item", Utils.getRegistryName((Item)e.getKey()).toString());
                if ((Integer)e.getValue() != 0) {
                    jo.addProperty("time", (Number)e.getValue());
                }
                return jo;
            }));
        }
        if (this.effects != null && !this.effects.isEmpty()) {
            json.add("effects", (JsonElement)SerializeUtil.toJsonList(this.effects, x -> {
                JsonObject jo = new JsonObject();
                jo.addProperty("level", (Number)((MobEffectInstance)x.getFirst()).m_19564_());
                jo.addProperty("time", (Number)((MobEffectInstance)x.getFirst()).m_19557_());
                jo.addProperty("effect", Utils.getRegistryName(((MobEffectInstance)x.getFirst()).m_19544_()).toString());
                jo.addProperty("chance", (Number)x.getSecond());
                return jo;
            }));
        }
        if (this.repersent != null) {
            json.add("item", Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.repersent}).m_43942_());
        }
    }

    public FoodValueRecipe(ResourceLocation id, FriendlyByteBuf data) {
        super(id);
        this.heal = data.m_130242_();
        this.sat = data.readFloat();
        this.processtimes = SerializeUtil.readList(data, d -> new Pair((Object)((Item)d.readRegistryIdUnsafe(ForgeRegistries.ITEMS)), (Object)d.m_130242_())).stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        this.effects = SerializeUtil.readList(data, d -> new Pair((Object)MobEffectInstance.m_19560_((CompoundTag)d.m_130260_()), (Object)Float.valueOf(d.readFloat())));
        this.repersent = SerializeUtil.readOptional(data, d -> ItemStack.m_41712_((CompoundTag)d.m_130260_())).orElse(null);
    }

    public void write(FriendlyByteBuf data) {
        data.m_130130_(this.heal);
        data.writeFloat(this.sat);
        SerializeUtil.writeList2(data, this.processtimes.entrySet(), (d, e) -> {
            d.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)((Item)e.getKey()));
            d.m_130130_(((Integer)e.getValue()).intValue());
        });
        SerializeUtil.writeList2(data, this.effects, (d, e) -> {
            CompoundTag nc = new CompoundTag();
            ((MobEffectInstance)e.getFirst()).m_19555_(nc);
            d.m_130079_(nc);
            d.writeFloat(((Float)e.getSecond()).floatValue());
        });
        SerializeUtil.writeOptional(data, this.repersent, (d, e) -> e.m_130079_(d.serializeNBT()));
    }

    public void clearCache() {
        this.tags = null;
    }

    public Set<ResourceLocation> getTags() {
        if (this.tags == null) {
            this.tags = this.processtimes.keySet().stream().flatMap(i -> ForgeRegistries.ITEMS.getHolder(i).map(Holder::m_203616_).orElseGet(Stream::empty).map(TagKey::f_203868_)).filter(CountingTags.tags::contains).collect(Collectors.toSet());
        }
        return this.tags;
    }

    public ItemStack getRepersent() {
        return this.repersent;
    }

    public void setRepersent(ItemStack repersent) {
        this.repersent = repersent != null ? repersent.m_41777_() : null;
    }
}

