/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.conditions;

import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.CachedDataDeserializer;
import com.teammoeg.caupona.data.Deserializer;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.data.recipes.IngredientCondition;
import com.teammoeg.caupona.data.recipes.conditions.Halfs;
import com.teammoeg.caupona.data.recipes.conditions.Mainly;
import com.teammoeg.caupona.data.recipes.conditions.MainlyOfType;
import com.teammoeg.caupona.data.recipes.conditions.Must;
import com.teammoeg.caupona.data.recipes.conditions.Only;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public class Conditions {
    private static CachedDataDeserializer<IngredientCondition, JsonObject> numbers = new CachedDataDeserializer<IngredientCondition, JsonObject>(){

        @Override
        protected IngredientCondition internalOf(JsonObject json) {
            return (IngredientCondition)this.getDeserializer(json.get("cond").getAsString()).read(json);
        }
    };

    public static void register(String name, Deserializer<JsonObject, IngredientCondition> des) {
        numbers.register(name, des);
    }

    public static void register(String name, Function<JsonObject, IngredientCondition> rjson, Function<FriendlyByteBuf, IngredientCondition> rpacket) {
        numbers.register(name, rjson, rpacket);
    }

    public static IngredientCondition of(JsonObject jsonElement) {
        return numbers.of(jsonElement);
    }

    public static IngredientCondition of(FriendlyByteBuf buffer) {
        return numbers.of(buffer);
    }

    public static void checkConditions(Collection<IngredientCondition> allow) {
        if (allow == null) {
            return;
        }
        boolean foundMajor = false;
        HashSet conts = new HashSet();
        for (IngredientCondition c : allow) {
            if (c.isMajor()) {
                if (foundMajor) {
                    throw new InvalidRecipeException("There must be less than one major condition. (Current: " + c.getType() + ")");
                }
                foundMajor = true;
                continue;
            }
            if (!c.isExclusive()) continue;
            if (conts.contains(c.getClass())) {
                throw new InvalidRecipeException("There must be less than one " + c.getType() + " condition.");
            }
            conts.add(c.getClass());
        }
    }

    public static void write(IngredientCondition e, FriendlyByteBuf buffer) {
        buffer.m_130070_(e.getType());
        e.write(buffer);
    }

    public static void clearCache() {
        numbers.clearCache();
    }

    static {
        Conditions.register("half", Halfs::new, Halfs::new);
        Conditions.register("mainly", Mainly::new, Mainly::new);
        Conditions.register("contains", Must::new, Must::new);
        Conditions.register("mainlyOf", MainlyOfType::new, MainlyOfType::new);
        Conditions.register("only", Only::new, Only::new);
    }
}

