/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ConstNumber
implements CookIngredients {
    float n;

    public ConstNumber(JsonElement num) {
        this.n = num.isJsonPrimitive() ? num.getAsFloat() : num.getAsJsonObject().get("num").getAsFloat();
    }

    public ConstNumber(float n) {
        this.n = n;
    }

    @Override
    public Float apply(IPendingContext t) {
        return Float.valueOf(this.n);
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return false;
    }

    @Override
    public JsonElement serialize() {
        return new JsonPrimitive((Number)Float.valueOf(this.n));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.n);
    }

    public ConstNumber(FriendlyByteBuf buffer) {
        this.n = buffer.readFloat();
    }

    @Override
    public String getType() {
        return "const";
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.empty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.n);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConstNumber)) {
            return false;
        }
        ConstNumber other = (ConstNumber)obj;
        return Float.floatToIntBits(this.n) == Float.floatToIntBits(other.n);
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return String.valueOf(this.n);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return Stream.of(new ItemStack[0]);
    }
}

