/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemTag
implements CookIngredients {
    ResourceLocation tag;

    public ItemTag(JsonElement jo) {
        this.tag = jo.isJsonObject() ? new ResourceLocation(jo.getAsJsonObject().get("tag").getAsString()) : new ResourceLocation(jo.getAsString());
    }

    public ItemTag(ResourceLocation tag) {
        this.tag = tag;
    }

    @Override
    public Float apply(IPendingContext t) {
        return Float.valueOf(t.getOfType(this.tag));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return stack.getTags().contains(this.tag);
    }

    @Override
    public JsonElement serialize() {
        return new JsonPrimitive(this.tag.toString());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.tag);
    }

    public ItemTag(FriendlyByteBuf buffer) {
        this.tag = buffer.m_130281_();
    }

    @Override
    public String getType() {
        return "tag";
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemTag)) {
            return false;
        }
        ItemTag other = (ItemTag)obj;
        return !(this.tag == null ? other.tag != null : !this.tag.equals((Object)other.tag));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.of(this.tag);
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslationOrElse("tag." + this.tag.m_214298_().replaceAll("/", "."), "#" + this.tag.toString(), new Object[0]);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)this.tag)).stream().map(ItemStack::new);
    }
}

