/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.teammoeg.caupona.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class SpicedFoodInfo {
    public MobEffectInstance spice;
    public boolean hasSpice = false;
    public ResourceLocation spiceName;

    public SpicedFoodInfo() {
    }

    public SpicedFoodInfo(CompoundTag nbt) {
        this.hasSpice = nbt.m_128471_("hasSpice");
        if (nbt.m_128441_("spice")) {
            this.spice = MobEffectInstance.m_19560_((CompoundTag)nbt.m_128469_("spice"));
        }
        if (nbt.m_128441_("spiceName")) {
            this.spiceName = new ResourceLocation(nbt.m_128461_("spiceName"));
        }
    }

    public static ResourceLocation getSpice(CompoundTag nbt) {
        if (nbt.m_128441_("spiceName")) {
            return new ResourceLocation(nbt.m_128461_("spiceName"));
        }
        return null;
    }

    public boolean addSpice(MobEffectInstance spice, ItemStack im) {
        if (this.spice != null) {
            return false;
        }
        this.spice = new MobEffectInstance(spice);
        this.hasSpice = true;
        this.spiceName = Utils.getRegistryName(im);
        return true;
    }

    public void clearSpice() {
        this.spice = null;
        this.hasSpice = false;
        this.spiceName = null;
    }

    public boolean canAddSpice() {
        return !this.hasSpice;
    }

    public void write(CompoundTag nbt) {
        nbt.m_128379_("hasSpice", this.hasSpice);
        if (this.spice != null) {
            nbt.m_128365_("spice", (Tag)this.spice.m_19555_(new CompoundTag()));
        }
        if (this.spiceName != null) {
            nbt.m_128359_("spiceName", this.spiceName.toString());
        }
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        this.write(nbt);
        return nbt;
    }
}

