/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.caupona.api.events.ContanerContainFoodEvent;
import com.teammoeg.caupona.api.events.FoodExchangeItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class Utils {
    public static final Direction[] horizontals = new Direction[]{Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH};
    public static final String FLUID_TAG_KEY = "caupona:fluid";

    private Utils() {
    }

    public static ContanerContainFoodEvent contain(ItemStack its2, FluidStack fs, boolean simulate) {
        ContanerContainFoodEvent ev = new ContanerContainFoodEvent(its2, fs, simulate, false);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev;
    }

    public static ContanerContainFoodEvent containBlock(ItemStack its2, FluidStack fs) {
        ContanerContainFoodEvent ev = new ContanerContainFoodEvent(its2, fs, false, true);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev;
    }

    public static ItemStack extractOutput(IItemHandler inv, int count) {
        ItemStack is = ItemStack.f_41583_;
        for (int i = 0; i < inv.getSlots() && (is = inv.extractItem(i, count, false)).m_41619_(); ++i) {
        }
        return is;
    }

    public static boolean isExtractAllowed(ItemStack is) {
        FoodExchangeItemEvent.Pre ev = new FoodExchangeItemEvent.Pre(is);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == Event.Result.ALLOW;
    }

    public static boolean isExchangeAllowed(ItemStack or, ItemStack rs) {
        FoodExchangeItemEvent.Post ev = new FoodExchangeItemEvent.Post(or, rs);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getResult() == Event.Result.ALLOW;
    }

    public static void writeItemFluid(ItemStack is, FluidStack stack) {
        CompoundTag tag = is.m_41698_(FLUID_TAG_KEY);
        if (stack.hasTag()) {
            tag.m_128365_("data", (Tag)stack.getTag());
        }
        tag.m_128359_("type", Utils.getRegistryName(stack).toString());
    }

    public static void writeItemFluid(ItemStack is, Fluid stack) {
        is.m_41698_(FLUID_TAG_KEY).m_128359_("type", Utils.getRegistryName(stack).toString());
    }

    public static void writeItemFluid(ItemStack is, ResourceLocation rl) {
        is.m_41698_(FLUID_TAG_KEY).m_128359_("type", rl.toString());
    }

    public static FluidStack extractFluid(ItemStack item) {
        if (item.m_41782_()) {
            Fluid f;
            CompoundTag tag = item.m_41783_();
            if (tag.m_128441_(FLUID_TAG_KEY)) {
                Fluid f2 = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation((tag = tag.m_128469_(FLUID_TAG_KEY)).m_128461_("type")));
                if (f2 != null && f2 != Fluids.f_76191_) {
                    FluidStack res = new FluidStack(f2, 250);
                    if (tag.m_128441_("data")) {
                        CompoundTag ntag = tag.m_128469_("data");
                        res.setTag(ntag);
                    }
                    return res;
                }
            } else if (tag.m_128441_("type") && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("type")))) != null && f != Fluids.f_76191_) {
                FluidStack res = new FluidStack(f, 250);
                CompoundTag ntag = tag.m_6426_();
                ntag.m_128473_("type");
                if (!ntag.m_128456_()) {
                    res.setTag(ntag);
                }
                return res;
            }
        }
        return FluidStack.EMPTY;
    }

    public static CompoundTag extractData(ItemStack item) {
        if (item.m_41782_()) {
            CompoundTag tag = item.m_41783_();
            if (tag.m_128441_(FLUID_TAG_KEY)) {
                if ((tag = tag.m_128469_(FLUID_TAG_KEY)).m_128441_("data")) {
                    return tag.m_128469_("data");
                }
            } else {
                return tag;
            }
        }
        return null;
    }

    public static CompoundTag extractDataElement(ItemStack item, String key) {
        if (item.m_41782_()) {
            CompoundTag tag = item.m_41783_();
            if (tag.m_128441_(FLUID_TAG_KEY)) {
                CompoundTag data;
                if ((tag = tag.m_128469_(FLUID_TAG_KEY)).m_128441_("data") && (data = tag.m_128469_("data")).m_128441_(key)) {
                    return data.m_128469_(key);
                }
            } else {
                return tag.m_128469_(key);
            }
        }
        return null;
    }

    public static void setDataElement(ItemStack item, String key, CompoundTag data) {
        CompoundTag tag = item.m_41698_(FLUID_TAG_KEY);
        CompoundTag dat = tag.m_128469_("data");
        dat.m_128365_(key, (Tag)data);
        tag.m_128365_("data", (Tag)dat);
    }

    public static ResourceLocation getFluidTypeRL(ItemStack item) {
        if (item.m_41782_()) {
            CompoundTag tag = item.m_41783_();
            if (tag.m_128441_(FLUID_TAG_KEY)) {
                tag = tag.m_128469_(FLUID_TAG_KEY);
                return new ResourceLocation(tag.m_128461_("type"));
            }
            if (tag.m_128441_("type")) {
                return new ResourceLocation(tag.m_128461_("type"));
            }
        }
        return new ResourceLocation("minecraft:water");
    }

    public static Fluid getFluidType(ItemStack item) {
        if (item.m_41782_()) {
            CompoundTag tag = item.m_41783_();
            if (tag.m_128441_(FLUID_TAG_KEY)) {
                tag = tag.m_128469_(FLUID_TAG_KEY);
                return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("type")));
            }
            if (tag.m_128441_("type")) {
                return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("type")));
            }
        }
        return Fluids.f_76191_;
    }

    public static ItemStack insertToOutput(ItemStackHandler inv, int slot, ItemStack in) {
        ItemStack is = inv.getStackInSlot(slot);
        if (is.m_41619_()) {
            inv.setStackInSlot(slot, in.m_41620_(Math.min(inv.getSlotLimit(slot), in.m_41741_())));
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)in, (ItemStack)is)) {
            int limit = Math.min(inv.getSlotLimit(slot), is.m_41741_());
            limit -= is.m_41613_();
            limit = Math.min(limit, in.m_41613_());
            is.m_41769_(limit);
            in.m_41774_(limit);
        }
        return in;
    }

    public static void dropToWorld(Level level, ItemStack is, BlockPos pos) {
        if (!is.m_41619_() && !level.f_46443_) {
            ItemEntity entityitem = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), is);
            entityitem.m_32010_(40);
            entityitem.m_20256_(entityitem.m_20184_().m_82542_(0.0, 1.0, 0.0));
            level.m_7967_((Entity)entityitem);
        }
    }

    public static MutableComponent translate(String format, Object ... objects) {
        return Utils.translateWithFallback(format, null, objects);
    }

    public static MutableComponent translate(String format) {
        return Utils.translate(format, new Object[0]);
    }

    public static MutableComponent translateWithFallback(String format, String fallback, Object ... objects) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(format, fallback, objects));
    }

    public static MutableComponent translateWithFallback(String format, String fallback) {
        return Utils.translate(format, fallback, new Object[0]);
    }

    public static MutableComponent string(String content) {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(content));
    }

    public static ResourceLocation getRegistryName(Fluid f) {
        return ForgeRegistries.FLUIDS.getKey((Object)f);
    }

    public static ResourceLocation getRegistryName(RegistryObject<?> r) {
        return r.getId();
    }

    public static ResourceLocation getRegistryName(Item i) {
        return ForgeRegistries.ITEMS.getKey((Object)i);
    }

    public static ResourceLocation getRegistryName(ItemStack i) {
        return Utils.getRegistryName(i.m_41720_());
    }

    public static ResourceLocation getRegistryName(Block b) {
        return ForgeRegistries.BLOCKS.getKey((Object)b);
    }

    public static ResourceLocation getRegistryName(FluidStack f) {
        return Utils.getRegistryName(f.getFluid());
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (!list.isEmpty()) {
            for (MobEffectInstance effectinstance : list) {
                MutableComponent iformattabletextcomponent = Utils.translate(effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() > 0) {
                    iformattabletextcomponent = Utils.translate("potion.withAmplifier", iformattabletextcomponent, Utils.translate("potion.potency." + effectinstance.m_19564_()));
                }
                if (effectinstance.m_19557_() > 20) {
                    iformattabletextcomponent = Utils.translate("potion.withDuration", iformattabletextcomponent, MobEffectUtil.m_267641_((MobEffectInstance)effectinstance, (float)durationFactor));
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((Component)Component.m_237119_());
            lores.add((Component)Utils.translate("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)Utils.translate("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), ItemStack.f_41584_.format(d1), Utils.translate(((Attribute)pair.getFirst()).m_22087_())).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)Utils.translate("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), ItemStack.f_41584_.format(d1 *= -1.0), Utils.translate(((Attribute)pair.getFirst()).m_22087_())).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

