/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.api.client.ComputerCraftAPIClient;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.client.gui.ComputerScreen;
import dan200.computercraft.client.gui.DiskDriveScreen;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.gui.PrinterScreen;
import dan200.computercraft.client.gui.PrintoutScreen;
import dan200.computercraft.client.gui.TurtleScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.turtle.TurtleModemModeller;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class ClientRegistry {
    private static final String[] EXTRA_MODELS = new String[]{"block/turtle_colour", "block/turtle_elf_overlay", "block/turtle_rainbow_overlay", "block/turtle_trans_overlay"};

    private ClientRegistry() {
    }

    public static void register() {
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.SPEAKER.get(), TurtleUpgradeModeller.sided(new ResourceLocation("computercraft", "block/turtle_speaker_left"), new ResourceLocation("computercraft", "block/turtle_speaker_right")));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.WORKBENCH.get(), TurtleUpgradeModeller.sided(new ResourceLocation("computercraft", "block/turtle_crafting_table_left"), new ResourceLocation("computercraft", "block/turtle_crafting_table_right")));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.WIRELESS_MODEM_NORMAL.get(), new TurtleModemModeller(false));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.WIRELESS_MODEM_ADVANCED.get(), new TurtleModemModeller(true));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.TOOL.get(), TurtleUpgradeModeller.flatItem());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.MONITOR_NORMAL.get()), MonitorBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.MONITOR_ADVANCED.get()), MonitorBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.TURTLE_NORMAL.get()), TurtleBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModRegistry.BlockEntities.TURTLE_ADVANCED.get()), TurtleBlockEntityRenderer::new);
    }

    public static void registerMainThread() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.COMPUTER.get()), ComputerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.POCKET_COMPUTER.get()), ComputerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get()), NoTermComputerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.TURTLE.get()), TurtleScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.PRINTER.get()), PrinterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.DISK_DRIVE.get()), DiskDriveScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.PRINTOUT.get()), PrintoutScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.Menus.VIEW_COMPUTER.get()), ComputerScreen::new);
        ClientRegistry.registerItemProperty("state", new UnclampedPropertyFunction((stack, world, player, random) -> ClientPocketComputers.get(stack).getState().ordinal()), ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
        ClientRegistry.registerItemProperty("coloured", (stack, world, player, random) -> IColouredItem.getColourBasic(stack) != -1 ? 1.0f : 0.0f, ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
    }

    @SafeVarargs
    private static void registerItemProperty(String name, ClampedItemPropertyFunction getter, Supplier<? extends Item> ... items) {
        ResourceLocation id = new ResourceLocation("computercraft", name);
        for (Supplier<? extends Item> item : items) {
            ItemProperties.register((Item)item.get(), (ResourceLocation)id, (ItemPropertyFunction)getter);
        }
    }

    public static void registerReloadListeners(Consumer<PreparableReloadListener> register, Minecraft minecraft) {
        register.accept((PreparableReloadListener)GuiSprites.initialise(minecraft.m_91097_()));
    }

    public static void registerExtraModels(Consumer<ResourceLocation> register) {
        for (String model : EXTRA_MODELS) {
            register.accept(new ResourceLocation("computercraft", model));
        }
        TurtleUpgradeModellers.getDependencies().forEach(register);
    }

    public static void registerItemColours(BiConsumer<ItemColor, ItemLike> register) {
        register.accept((stack, layer) -> layer == 1 ? ((DiskItem)stack.m_41720_()).getColour(stack) : 0xFFFFFF, (ItemLike)ModRegistry.Items.DISK.get());
        register.accept((stack, layer) -> layer == 1 ? TreasureDiskItem.getColour(stack) : 0xFFFFFF, (ItemLike)ModRegistry.Items.TREASURE_DISK.get());
        register.accept(ClientRegistry::getPocketColour, (ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get());
        register.accept(ClientRegistry::getPocketColour, (ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
        register.accept(ClientRegistry::getTurtleColour, (ItemLike)ModRegistry.Blocks.TURTLE_NORMAL.get());
        register.accept(ClientRegistry::getTurtleColour, (ItemLike)ModRegistry.Blocks.TURTLE_ADVANCED.get());
    }

    private static int getPocketColour(ItemStack stack, int layer) {
        switch (layer) {
            default: {
                return 0xFFFFFF;
            }
            case 1: {
                return IColouredItem.getColourBasic(stack);
            }
            case 2: 
        }
        int light = ClientPocketComputers.get(stack).getLightState();
        return light == -1 ? Colour.BLACK.getHex() : light;
    }

    private static int getTurtleColour(ItemStack stack, int layer) {
        return layer == 0 ? ((IColouredItem)stack.m_41720_()).getColour(stack) : 0xFFFFFF;
    }

    public static void registerShaders(ResourceProvider resources, BiConsumer<ShaderInstance, Consumer<ShaderInstance>> load) throws IOException {
        RenderTypes.registerShaders(resources, load);
    }

    private record UnclampedPropertyFunction(ClampedItemPropertyFunction function) implements ClampedItemPropertyFunction
    {
        public float m_142187_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int layer) {
            return this.function.m_142187_(stack, level, entity, layer);
        }

        @Deprecated
        public float m_141951_(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int layer) {
            return this.function.m_142187_(stack, level, entity, layer);
        }
    }
}

