/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.ClientInputHandler;
import dan200.computercraft.client.gui.ItemToast;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.DynamicImageButton;
import dan200.computercraft.client.gui.widgets.TerminalWidget;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComputerScreen<T extends AbstractComputerMenu>
extends AbstractContainerScreen<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComputerScreen.class);
    private static final Component OK = Component.m_237115_((String)"gui.ok");
    private static final Component NO_RESPONSE_TITLE = Component.m_237115_((String)"gui.computercraft.upload.no_response");
    private static final Component NO_RESPONSE_MSG = Component.m_237110_((String)"gui.computercraft.upload.no_response.msg", (Object[])new Object[]{Component.m_237113_((String)"import").m_130940_(ChatFormatting.DARK_GRAY)});
    @Nullable
    protected TerminalWidget terminal;
    protected Terminal terminalData;
    protected final ComputerFamily family;
    protected final InputHandler input;
    protected final int sidebarYOffset;
    private long uploadNagDeadline = Long.MAX_VALUE;
    private final int uploadMaxSize;
    private final ItemStack displayStack;

    public AbstractComputerScreen(T container, Inventory player, Component title, int sidebarYOffset) {
        super(container, player, title);
        this.terminalData = ((AbstractComputerMenu)container).getTerminal();
        this.family = ((AbstractComputerMenu)container).getFamily();
        this.displayStack = ((AbstractComputerMenu)container).getDisplayStack();
        this.uploadMaxSize = ((AbstractComputerMenu)container).getUploadMaxSize();
        this.input = new ClientInputHandler(this.f_97732_);
        this.sidebarYOffset = sidebarYOffset;
    }

    protected abstract TerminalWidget createTerminal();

    protected final TerminalWidget getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Screen has not been initialised yet");
        }
        return this.terminal;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.terminal = (TerminalWidget)this.m_142416_((GuiEventListener)this.createTerminal());
        ComputerSidebar.addButtons(((AbstractComputerMenu)this.f_97732_)::isOn, this.input, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, this.f_97735_, this.f_97736_ + this.sidebarYOffset);
        this.m_7522_((GuiEventListener)this.terminal);
    }

    public void m_181908_() {
        super.m_181908_();
        this.getTerminal().update();
        if (this.uploadNagDeadline != Long.MAX_VALUE && Util.m_137569_() >= this.uploadNagDeadline) {
            new ItemToast(this.f_96541_, this.displayStack, NO_RESPONSE_TITLE, NO_RESPONSE_MSG, ItemToast.TRANSFER_NO_RESPONSE_TOKEN).showOrReplace(this.f_96541_.m_91300_());
            this.uploadNagDeadline = Long.MAX_VALUE;
        }
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 258 && this.m_7222_() != null && this.m_7222_() == this.terminal) {
            return this.m_7222_().m_7933_(key, scancode, modifiers);
        }
        return super.m_7933_(key, scancode, modifiers);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.m_7897_(false);
        Optional child = this.m_94729_(x, y);
        if (child.isPresent() && ((GuiEventListener)child.get()).m_6348_(x, y, button)) {
            return true;
        }
        return super.m_6348_(x, y, button);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean changed = super.m_6375_(x, y, button);
        if (this.m_7222_() instanceof DynamicImageButton) {
            this.m_7522_((GuiEventListener)this.terminal);
        }
        return changed;
    }

    public boolean m_7979_(double x, double y, int button, double deltaX, double deltaY) {
        return this.m_7222_() != null && this.m_7222_().m_7979_(x, y, button, deltaX, deltaY) || super.m_7979_(x, y, button, deltaX, deltaY);
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        if (listener != this.m_7222_()) {
            super.m_7522_(listener);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void m_7400_(List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        if (!((AbstractComputerMenu)this.f_97732_).isOn()) {
            this.alert(UploadResult.FAILED_TITLE, UploadResult.COMPUTER_OFF_MSG);
            return;
        }
        long size = 0L;
        ArrayList<FileUpload> toUpload = new ArrayList<FileUpload>();
        for (Path file : files) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(file, new OpenOption[0]);
                try {
                    long fileSize = sbc.size();
                    if (fileSize > (long)this.uploadMaxSize || (size += fileSize) >= (long)this.uploadMaxSize) {
                        this.alert(UploadResult.FAILED_TITLE, UploadResult.TOO_MUCH_MSG);
                        return;
                    }
                    String name = file.getFileName().toString();
                    if (name.length() > 128) {
                        this.alert(UploadResult.FAILED_TITLE, (Component)Component.m_237115_((String)"gui.computercraft.upload.failed.name_too_long"));
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.allocateDirect((int)fileSize);
                    sbc.read(buffer);
                    buffer.flip();
                    byte[] digest = FileUpload.getDigest(buffer);
                    if (digest == null) {
                        this.alert(UploadResult.FAILED_TITLE, (Component)Component.m_237115_((String)"gui.computercraft.upload.failed.corrupted"));
                        return;
                    }
                    toUpload.add(new FileUpload(name, buffer, digest));
                }
                finally {
                    if (sbc == null) continue;
                    sbc.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed uploading files", (Throwable)e);
                this.alert(UploadResult.FAILED_TITLE, (Component)Component.m_237110_((String)"gui.computercraft.upload.failed.generic", (Object[])new Object[]{"Cannot compute checksum"}));
            }
        }
        if (toUpload.size() > 32) {
            this.alert(UploadResult.FAILED_TITLE, (Component)Component.m_237115_((String)"gui.computercraft.upload.failed.too_many_files"));
            return;
        }
        if (toUpload.size() > 0) {
            UploadFileMessage.send(this.f_97732_, toUpload, ClientPlatformHelper.get()::sendToServer);
        }
    }

    public void uploadResult(UploadResult result, @Nullable Component message) {
        switch (result) {
            case QUEUED: {
                if (Config.uploadNagDelay <= 0) break;
                this.uploadNagDeadline = Util.m_137569_() + TimeUnit.SECONDS.toNanos(Config.uploadNagDelay);
                break;
            }
            case CONSUMED: {
                this.uploadNagDeadline = Long.MAX_VALUE;
                break;
            }
            case ERROR: {
                this.alert(UploadResult.FAILED_TITLE, Nullability.assertNonNull(message));
            }
        }
    }

    private void alert(Component title, Component message) {
        OptionScreen.show(this.f_96541_, title, message, List.of(OptionScreen.newButton(OK, b -> this.f_96541_.m_91152_((Screen)this))), () -> this.f_96541_.m_91152_((Screen)this));
    }
}

