/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.platform;

import dan200.computercraft.client.ClientTableFormatter;
import dan200.computercraft.client.gui.AbstractComputerScreen;
import dan200.computercraft.client.gui.OptionScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractClientNetworkContext
implements ClientNetworkContext {
    @Override
    public final void handleChatTable(TableBuilder table) {
        ClientTableFormatter.INSTANCE.display(table);
    }

    @Override
    public final void handleComputerTerminal(int containerId, TerminalState terminal) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.f_36096_.f_38840_ == containerId && (abstractContainerMenu = player.f_36096_) instanceof ComputerMenu) {
            ComputerMenu menu = (ComputerMenu)abstractContainerMenu;
            menu.updateTerminal(terminal);
        }
    }

    @Override
    public final void handleMonitorData(BlockPos pos, TerminalState terminal) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BlockEntity te = player.m_9236_().m_7702_(pos);
        if (!(te instanceof MonitorBlockEntity)) {
            return;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)te;
        monitor.read(terminal);
    }

    @Override
    public final void handlePocketComputerData(int instanceId, ComputerState state, int lightState, TerminalState terminal) {
        PocketComputerData computer = ClientPocketComputers.get(instanceId, terminal.colour);
        computer.setState(state, lightState);
        if (terminal.hasTerminal()) {
            computer.setTerminal(terminal);
        }
    }

    @Override
    public final void handlePocketComputerDeleted(int instanceId) {
        ClientPocketComputers.remove(instanceId);
    }

    @Override
    public final void handleSpeakerAudio(UUID source, SpeakerPosition.Message position, float volume) {
        SpeakerManager.getSound(source).playAudio(AbstractClientNetworkContext.reifyPosition(position), volume);
    }

    @Override
    public final void handleSpeakerAudioPush(UUID source, ByteBuf buffer) {
        SpeakerManager.getSound(source).pushAudio(buffer);
    }

    @Override
    public final void handleSpeakerMove(UUID source, SpeakerPosition.Message position) {
        SpeakerManager.moveSound(source, AbstractClientNetworkContext.reifyPosition(position));
    }

    @Override
    public final void handleSpeakerPlay(UUID source, SpeakerPosition.Message position, ResourceLocation sound, float volume, float pitch) {
        SpeakerManager.getSound(source).playSound(AbstractClientNetworkContext.reifyPosition(position), sound, volume, pitch);
    }

    @Override
    public final void handleSpeakerStop(UUID source) {
        SpeakerManager.stopSound(source);
    }

    @Override
    public final void handleUploadResult(int containerId, UploadResult result, @Nullable Component errorMessage) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = OptionScreen.unwrap(minecraft.f_91080_);
        if (screen instanceof AbstractComputerScreen && ((AbstractComputerMenu)((AbstractComputerScreen)screen).m_6262_()).f_38840_ == containerId) {
            ((AbstractComputerScreen)screen).uploadResult(result, errorMessage);
        }
    }

    private static SpeakerPosition reifyPosition(SpeakerPosition.Message pos) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null && !level.m_46472_().m_135782_().equals((Object)pos.level())) {
            level = null;
        }
        return new SpeakerPosition((Level)level, pos.position(), level != null && pos.entity().isPresent() ? level.m_6815_(pos.entity().getAsInt()) : null);
    }
}

