/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.platform;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.client.model.FoiledModel;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.render.ModelRenderer;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.platform.NetworkHandler;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;

@AutoService(value={dan200.computercraft.impl.client.ClientPlatformHelper.class})
public class ClientPlatformHelperImpl
implements ClientPlatformHelper {
    private static final RandomSource random = RandomSource.m_216335_((long)0L);
    private static final Direction[] directions = Arrays.copyOf(Direction.values(), 7);

    @Override
    public BakedModel getModel(ModelManager manager, ResourceLocation location) {
        return manager.getModel(location);
    }

    @Override
    public BakedModel createdFoiledModel(BakedModel model) {
        return new FoiledModel(model);
    }

    @Override
    public void sendToServer(NetworkMessage<ServerNetworkContext> message) {
        NetworkHandler.sendToServer(message);
    }

    @Override
    public void renderBakedModel(PoseStack transform, MultiBufferSource buffers, BakedModel model, int lightmapCoord, int overlayLight, @Nullable int[] tints) {
        for (RenderType renderType : model.getRenderTypes(ItemStack.f_41583_, true)) {
            VertexConsumer buffer = buffers.m_6299_(renderType);
            for (Direction face : directions) {
                random.m_188584_(42L);
                List quads = model.getQuads(null, face, random, ModelData.EMPTY, renderType);
                ModelRenderer.renderQuads(transform, buffer, quads, lightmapCoord, overlayLight, tints);
            }
        }
    }
}

