/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ClientPocketComputers {
    private static final Int2ObjectMap<PocketComputerData> instances = new Int2ObjectOpenHashMap();

    private ClientPocketComputers() {
    }

    public static void reset() {
        instances.clear();
    }

    public static void remove(int id) {
        instances.remove(id);
    }

    public static PocketComputerData get(int instanceId, boolean advanced) {
        PocketComputerData computer = (PocketComputerData)instances.get(instanceId);
        if (computer == null) {
            computer = new PocketComputerData(advanced);
            instances.put(instanceId, (Object)computer);
        }
        return computer;
    }

    public static PocketComputerData get(ItemStack stack) {
        ComputerFamily computerFamily;
        Item item = stack.m_41720_();
        if (item instanceof PocketComputerItem) {
            PocketComputerItem computer = (PocketComputerItem)item;
            computerFamily = computer.getFamily();
        } else {
            computerFamily = ComputerFamily.NORMAL;
        }
        ComputerFamily family = computerFamily;
        return ClientPocketComputers.get(PocketComputerItem.getInstanceID(stack), family != ComputerFamily.NORMAL);
    }
}

