/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.google.common.base.Strings;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.computer.blocks.IComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractComputerBlockEntity
extends BlockEntity
implements IComputerBlockEntity,
Nameable,
MenuProvider {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private int instanceID = -1;
    private int computerID = -1;
    @Nullable
    protected String label = null;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private final ComponentAccess<IPeripheral> peripherals = PlatformHelper.get().createPeripheralAccess(d -> this.invalidSides |= 1 << d.ordinal());
    private LockCode lockCode = LockCode.f_19102_;
    private final ComputerFamily family;

    public AbstractComputerBlockEntity(BlockEntityType<? extends AbstractComputerBlockEntity> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state);
        this.family = family;
    }

    protected void unload() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.close();
        }
        this.instanceID = -1;
    }

    public void m_7651_() {
        super.m_7651_();
        this.unload();
    }

    protected boolean canNameWithTag(Player player) {
        return false;
    }

    protected double getInteractRange() {
        return 8.0;
    }

    public boolean isUsable(Player player) {
        return BaseContainerBlockEntity.m_58629_((Player)player, (LockCode)this.lockCode, (Component)this.m_5446_()) && BlockEntityHelpers.isUsable(this, player, this.getInteractRange());
    }

    public InteractionResult use(Player player, InteractionHand hand) {
        ItemStack currentItem = player.m_21120_(hand);
        if (!currentItem.m_41619_() && currentItem.m_41720_() == Items.f_42656_ && this.canNameWithTag(player) && currentItem.m_41788_()) {
            if (!this.m_58904_().f_46443_) {
                this.setLabel(currentItem.m_41786_().getString());
                currentItem.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
        }
        if (!player.m_6047_()) {
            if (!this.m_58904_().f_46443_ && this.isUsable(player)) {
                ServerComputer computer = this.createServerComputer();
                computer.turnOn();
                ItemStack stack = this.m_58900_().m_60734_() instanceof AbstractComputerBlock ? ((AbstractComputerBlock)this.m_58900_().m_60734_()).getItem(this) : ItemStack.f_41583_;
                new ComputerContainerData(computer, stack).open(player, this);
            }
            return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockPos neighbour) {
        this.updateInputAt(neighbour);
    }

    protected void serverTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        this.label = computer.getLabel();
        this.on = computer.isOn();
        this.updateBlockState(computer.getState());
        if (computer.hasOutputChanged()) {
            this.updateOutput();
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void m_183515_(CompoundTag nbt) {
        if (this.computerID >= 0) {
            nbt.m_128405_(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.m_128359_(NBT_LABEL, this.label);
        }
        nbt.m_128379_(NBT_ON, this.on);
        this.lockCode.m_19109_(nbt);
        super.m_183515_(nbt);
    }

    public final void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loadClient(nbt);
        } else {
            this.loadServer(nbt);
        }
    }

    protected void loadServer(CompoundTag nbt) {
        this.computerID = nbt.m_128441_(NBT_ID) ? nbt.m_128451_(NBT_ID) : -1;
        this.label = nbt.m_128441_(NBT_LABEL) ? nbt.m_128461_(NBT_LABEL) : null;
        this.on = this.startOn = nbt.m_128471_(NBT_ON);
        this.lockCode = LockCode.m_19111_((CompoundTag)nbt);
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract Direction getDirection();

    protected ComputerSide remapToLocalSide(Direction globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInputs(ServerComputer computer) {
        BlockPos pos = this.m_58899_();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.m_121945_(dir));
        }
    }

    private void updateRedstoneInput(ServerComputer computer, Direction dir, BlockPos targetPos) {
        Direction offsetSide = dir.m_122424_();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.f_58857_, targetPos, dir));
        computer.setBundledRedstoneInput(localDir, BundledRedstone.getOutput(this.m_58904_(), targetPos, offsetSide));
    }

    private void refreshPeripheral(ServerComputer computer, Direction dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        IPeripheral peripheral = this.peripherals.get((ServerLevel)this.m_58904_(), this.m_58899_(), dir);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(ServerComputer computer) {
        BlockPos pos = this.m_58899_();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.m_121945_(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    private void updateInputAt(BlockPos neighbour) {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = this.m_58899_().m_121945_(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(computer, dir, offset);
            this.invalidSides |= 1 << dir.ordinal();
            return;
        }
        this.updateRedstoneInputs(computer);
        this.invalidSides = 63;
    }

    public void updateOutput() {
        BlockEntityHelpers.updateBlock(this);
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.m_58904_(), this.m_58899_(), dir);
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateRedstoneInputs(computer);
        }
    }

    protected abstract ServerComputer createComputer(int var1);

    @Override
    public final int getComputerID() {
        return this.computerID;
    }

    @Override
    @Nullable
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setComputerID(int id) {
        if (this.m_58904_().f_46443_ || this.computerID == id) {
            return;
        }
        this.computerID = id;
        this.m_6596_();
    }

    @Override
    public final void setLabel(@Nullable String label) {
        if (this.m_58904_().f_46443_ || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        this.m_6596_();
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    public final ServerComputer createServerComputer() {
        MinecraftServer server = this.m_58904_().m_7654_();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get(server).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(server, "computer");
                BlockEntityHelpers.updateBlock(this);
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    @Nullable
    public ServerComputer getServerComputer() {
        return this.m_58904_().f_46443_ || this.m_58904_().m_7654_() == null ? null : ServerContext.get(this.m_58904_().m_7654_()).registry().get(this.instanceID);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.label != null) {
            nbt.m_128359_(NBT_LABEL, this.label);
        }
        if (this.computerID >= 0) {
            nbt.m_128405_(NBT_ID, this.computerID);
        }
        return nbt;
    }

    protected void loadClient(CompoundTag nbt) {
        this.label = nbt.m_128441_(NBT_LABEL) ? nbt.m_128461_(NBT_LABEL) : null;
        this.computerID = nbt.m_128441_(NBT_ID) ? nbt.m_128451_(NBT_ID) : -1;
    }

    protected void transferStateFrom(AbstractComputerBlockEntity copy) {
        if (copy.computerID != this.computerID || copy.instanceID != this.instanceID) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.lockCode = copy.lockCode;
            BlockEntityHelpers.updateBlock(this);
        }
        copy.instanceID = -1;
    }

    public Component m_7755_() {
        return this.m_8077_() ? Component.m_237113_((String)this.label) : Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public boolean m_8077_() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    @Nullable
    public Component m_7770_() {
        return this.m_8077_() ? Component.m_237113_((String)this.label) : null;
    }

    public Component m_5446_() {
        return super.m_5446_();
    }
}

