/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.generic.ComponentLookup;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericPeripheralProvider<C extends Runnable> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPeripheralProvider.class);
    private final List<ComponentLookup<? super C>> lookups = new ArrayList<ComponentLookup<? super C>>();

    public synchronized void registerLookup(ComponentLookup<? super C> lookup) {
        Objects.requireNonNull(lookup);
        if (!this.lookups.contains(lookup)) {
            this.lookups.add(lookup);
        }
    }

    public void forEachMethod(MethodSupplier<PeripheralMethod> methods, Level level, BlockPos pos, Direction side, BlockEntity blockEntity, C invalidate, MethodSupplier.TargetedConsumer<PeripheralMethod> consumer) {
        methods.forEachMethod(blockEntity, consumer);
        for (ComponentLookup<C> lookup : this.lookups) {
            Object contents = lookup.find(level, pos, blockEntity.m_58900_(), blockEntity, side, invalidate);
            if (contents == null) continue;
            methods.forEachMethod(contents, consumer);
        }
    }

    @Nullable
    public IPeripheral getPeripheral(Level level, BlockPos pos, Direction side, @Nullable BlockEntity blockEntity, C invalidate) {
        if (blockEntity == null) {
            return null;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            LOG.warn("Fetching peripherals on a non-server level {}.", (Object)level, (Object)new IllegalStateException("Fetching peripherals on a non-server level."));
            return null;
        }
        GenericPeripheralBuilder builder = new GenericPeripheralBuilder();
        this.forEachMethod(ServerContext.get(server).peripheralMethods(), level, pos, side, blockEntity, invalidate, builder::addMethod);
        return builder.toPeripheral(blockEntity, side);
    }
}

