/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CableBlockEntity
extends BlockEntity {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private boolean invalidPeripheral;
    private boolean peripheralAccessAllowed;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(this::queueRefreshPeripheral);
    @Nullable
    private Runnable modemChanged;
    private boolean connectionsFormed = false;
    private final WiredModemElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this.tickToken)), this.cable){

        @Override
        protected WiredModemLocalPeripheral getLocalPeripheral() {
            return CableBlockEntity.this.peripheral;
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)CableBlockEntity.this.m_58899_().m_121945_(CableBlockEntity.this.getDirection()));
        }

        @Override
        public Object getTarget() {
            return CableBlockEntity.this;
        }
    };
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(x -> this.connectionsChanged());

    public CableBlockEntity(BlockEntityType<? extends CableBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void onRemove() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.modem.removed();
        this.onRemove();
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void m_155250_(BlockState state) {
        Direction direction = this.getMaybeDirection();
        super.m_155250_(state);
        if (this.getMaybeDirection() != direction && this.modemChanged != null) {
            this.modemChanged.run();
        }
    }

    @Nullable
    private Direction getMaybeDirection() {
        return ((CableModemVariant)((Object)this.m_58900_().m_61143_(CableBlock.MODEM))).getFacing();
    }

    private Direction getDirection() {
        Direction direction = this.getMaybeDirection();
        return direction == null ? Direction.NORTH : direction;
    }

    void neighborChanged(BlockPos neighbour) {
        Direction dir = this.getDirection();
        if (neighbour.equals((Object)this.m_58899_().m_121945_(dir)) && this.hasModem() && !this.m_58900_().m_60710_((LevelReader)this.m_58904_(), this.m_58899_())) {
            if (this.hasCable()) {
                Block.m_49840_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get()));
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.None)));
                this.modemChanged();
                this.connectionsChanged();
            } else {
                Block.m_49840_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)ModRegistry.Items.WIRED_MODEM.get()));
                this.m_58904_().m_7471_(this.m_58899_(), false);
            }
            return;
        }
        if (!this.f_58857_.f_46443_ && this.peripheralAccessAllowed) {
            Direction facing = this.getDirection();
            if (this.m_58899_().m_121945_(facing).equals((Object)neighbour)) {
                this.queueRefreshPeripheral();
            }
        }
    }

    private void queueRefreshPeripheral() {
        if (this.invalidPeripheral) {
            return;
        }
        this.invalidPeripheral = true;
        TickScheduler.schedule(this.tickToken);
    }

    private void refreshPeripheral() {
        this.invalidPeripheral = false;
        if (this.f_58857_ != null && !this.m_58901_() && this.peripheral.attach(this.f_58857_, this.m_58899_(), this.getDirection())) {
            this.updateConnectedPeripherals();
        }
    }

    InteractionResult use(Player player) {
        if (player.m_6047_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (!this.canAttachPeripheral()) {
            return InteractionResult.FAIL;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        this.togglePeripheralAccess();
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equals(newName, oldName)) {
            if (oldName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.peripheralAccessAllowed = nbt.m_128471_(NBT_PERIPHERAL_ENABLED) || nbt.m_128471_("PeirpheralAccess");
        this.peripheral.read(nbt, "");
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        this.peripheral.write(nbt, "");
        super.m_183515_(nbt);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        BlockState state = this.m_58900_();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.m_61143_(CableBlock.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheralAccessAllowed))) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_(CableBlock.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.invalidPeripheral) {
            this.refreshPeripheral();
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                this.peripheral.attach(this.f_58857_, this.f_58858_, this.getDirection());
                this.updateConnectedPeripherals();
            }
        }
    }

    void connectionsChanged() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        Level world = this.m_58904_();
        BlockPos current = this.m_58899_();
        for (Direction facing : DirectionUtil.FACINGS) {
            WiredElement element;
            BlockPos offset = current.m_121945_(facing);
            if (!world.m_46749_(offset) || (element = this.connectedElements.get((ServerLevel)world, current, facing)) == null) continue;
            WiredNode node = element.getNode();
            if (CableBlock.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            if (this.node.getNetwork() != node.getNetwork()) continue;
            this.node.disconnectFrom(node);
        }
    }

    void modemChanged() {
        if (this.modemChanged != null) {
            this.modemChanged.run();
        }
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (!this.canAttachPeripheral() && this.peripheralAccessAllowed) {
            this.peripheralAccessAllowed = false;
            this.peripheral.detach();
            this.node.updatePeripherals(Map.of());
            this.m_6596_();
            this.updateBlockState();
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            this.peripheral.attach(this.f_58857_, this.m_58899_(), this.getDirection());
            if (!this.peripheral.hasPeripheral()) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.peripheral.toMap());
        } else {
            this.peripheral.detach();
            this.peripheralAccessAllowed = false;
            this.node.updatePeripherals(Map.of());
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.peripheral.toMap();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    @Nullable
    public WiredElement getWiredElement(@Nullable Direction direction) {
        return direction == null || CableBlock.canConnectIn(this.m_58900_(), direction) ? this.cable : null;
    }

    @Nullable
    public IPeripheral getPeripheral(@Nullable Direction direction) {
        return direction == null || this.getMaybeDirection() == direction ? this.modem : null;
    }

    public void onModemChanged(Runnable callback) {
        this.modemChanged = callback;
    }

    boolean hasCable() {
        return (Boolean)this.m_58900_().m_61143_((Property)CableBlock.CABLE);
    }

    public boolean hasModem() {
        return this.m_58900_().m_61143_(CableBlock.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private final class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        public Level getLevel() {
            return CableBlockEntity.this.m_58904_();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)CableBlockEntity.this.m_58899_());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CableBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            CableBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

