/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkHandler.class);
    private static final SimpleChannel network;

    private NetworkHandler() {
    }

    public static void setup() {
        IntOpenHashSet usedIds = new IntOpenHashSet();
        NetworkMessages.register(new NetworkMessages.PacketRegistry((IntSet)usedIds){
            final /* synthetic */ IntSet val$usedIds;
            {
                this.val$usedIds = intSet;
            }

            @Override
            public <T extends NetworkMessage<ClientNetworkContext>> void registerClientbound(int id, Class<T> type, Function<FriendlyByteBuf, T> decoder) {
                if (!this.val$usedIds.add(id)) {
                    throw new IllegalArgumentException("Already have a packet with id " + id);
                }
                NetworkHandler.registerMainThread(id, NetworkDirection.PLAY_TO_CLIENT, type, decoder, x -> ClientNetworkContext.get());
            }

            @Override
            public <T extends NetworkMessage<ServerNetworkContext>> void registerServerbound(int id, Class<T> type, Function<FriendlyByteBuf, T> decoder) {
                if (!this.val$usedIds.add(id)) {
                    throw new IllegalArgumentException("Already have a packet with id " + id);
                }
                NetworkHandler.registerMainThread(id, NetworkDirection.PLAY_TO_SERVER, type, decoder, c -> () -> Nullability.assertNonNull(c.getSender()));
            }
        });
    }

    static void sendToPlayer(NetworkMessage<ClientNetworkContext> packet, ServerPlayer player) {
        network.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    static void sendToPlayers(NetworkMessage<ClientNetworkContext> packet, Collection<ServerPlayer> players) {
        if (players.isEmpty()) {
            return;
        }
        Packet vanillaPacket = network.toVanillaPacket(packet, NetworkDirection.PLAY_TO_CLIENT);
        for (ServerPlayer player : players) {
            player.f_8906_.m_9829_(vanillaPacket);
        }
    }

    static void sendToAllPlayers(NetworkMessage<ClientNetworkContext> packet) {
        network.send(PacketDistributor.ALL.noArg(), packet);
    }

    static void sendToAllAround(NetworkMessage<ClientNetworkContext> packet, Level world, Vec3 pos, double range) {
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, range, world.m_46472_());
        network.send(PacketDistributor.NEAR.with(() -> target), packet);
    }

    static void sendToAllTracking(NetworkMessage<ClientNetworkContext> packet, LevelChunk chunk) {
        network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), packet);
    }

    public static void sendToServer(NetworkMessage<ServerNetworkContext> packet) {
        network.sendToServer(packet);
    }

    static <H, T extends NetworkMessage<H>> void registerMainThread(int id, NetworkDirection direction, Class<T> type, Function<FriendlyByteBuf, T> decoder, Function<NetworkEvent.Context, H> handler) {
        network.messageBuilder(type, id, direction).encoder(NetworkMessage::toBytes).decoder(decoder).consumerMainThread((packet, contextSup) -> {
            try {
                packet.handle(handler.apply((NetworkEvent.Context)contextSup.get()));
            }
            catch (Error | RuntimeException e) {
                LOG.error("Failed handling packet", e);
                throw e;
            }
        }).add();
    }

    static {
        String version = ComputerCraftAPI.getInstalledVersion();
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("computercraft", "network")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
    }
}

