/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    @Nullable
    private IPocketUpgrade upgrade;
    @Nullable
    private Entity entity;
    private ItemStack stack = ItemStack.f_41583_;
    private int lightColour = -1;
    private boolean lightChanged = false;
    private final Set<ServerPlayer> tracking = new HashSet<ServerPlayer>();

    public PocketServerComputer(ServerLevel world, BlockPos position, int computerID, @Nullable String label, ComputerFamily family) {
        super(world, position, computerID, label, family, Config.pocketTermWidth, Config.pocketTermHeight);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        Entity entity = this.entity;
        if (entity == null || this.stack.m_41619_() || !entity.m_6084_()) {
            return null;
        }
        if (entity instanceof Player) {
            Inventory inventory = ((Player)entity).m_150109_();
            return inventory.f_35974_.contains((Object)this.stack) || inventory.f_35976_.contains((Object)this.stack) ? entity : null;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.m_21205_() == this.stack || living.m_21206_() == this.stack ? entity : null;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemEntity.m_32055_() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        return this.lightColour;
    }

    @Override
    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        if (this.lightColour == colour) {
            return;
        }
        this.lightColour = colour;
        this.lightChanged = true;
    }

    @Override
    public CompoundTag getUpgradeNBTData() {
        return PocketComputerItem.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_150109_().m_6596_();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Deprecated(forRemoval=true)
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Map.of() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    @Nullable
    public UpgradeData<IPocketUpgrade> getUpgrade() {
        return this.upgrade == null ? null : UpgradeData.of(this.upgrade, this.getUpgradeNBTData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            PocketComputerItem.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade == null ? null : upgrade.upgrade();
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(@Nullable Entity entity, ItemStack stack, @Nullable IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setLevel((ServerLevel)entity.m_20193_());
            this.setPosition(entity.m_20183_());
        }
        if (entity != this.entity && entity instanceof ServerPlayer) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.tracking.removeIf(player -> !player.m_6084_() || player.m_9236_() != this.getLevel());
        boolean sendState = this.hasOutputChanged() || this.lightChanged;
        this.lightChanged = false;
        if (sendState) {
            this.tracking.addAll(this.getLevel().m_6907_());
            PlatformHelper.get().sendToPlayers(new PocketComputerDataMessage(this, false), this.tracking);
        } else {
            ArrayList<ServerPlayer> added = new ArrayList<ServerPlayer>();
            for (ServerPlayer player2 : this.getLevel().m_6907_()) {
                if (!this.tracking.add(player2)) continue;
                added.add(player2);
            }
            if (!added.isEmpty()) {
                PlatformHelper.get().sendToPlayers(new PocketComputerDataMessage(this, false), added);
            }
        }
    }

    @Override
    protected void onTerminalChanged() {
        super.onTerminalChanged();
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.entity.m_6084_()) {
                PlatformHelper.get().sendToPlayer(new PocketComputerDataMessage(this, true), player);
            }
        }
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        PlatformHelper.get().sendToAllPlayers(new PocketComputerDeletedClientMessage(this.getInstanceID()), this.getLevel().m_7654_());
    }
}

