/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import com.google.gson.JsonObject;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.recipe.CustomShapelessRecipe;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class TurtleOverlayRecipe
extends CustomShapelessRecipe {
    private final ResourceLocation overlay;

    public TurtleOverlayRecipe(ResourceLocation id, ShapelessRecipeSpec spec, ResourceLocation overlay) {
        super(id, spec);
        this.overlay = overlay;
    }

    private static ItemStack make(ItemStack stack, ResourceLocation overlay) {
        TurtleItem turtle = (TurtleItem)stack.m_41720_();
        return turtle.create(turtle.getComputerID(stack), turtle.getLabel(stack), turtle.getColour(stack), turtle.getUpgradeWithData(stack, TurtleSide.LEFT), turtle.getUpgradeWithData(stack, TurtleSide.RIGHT), turtle.getFuelLevel(stack), overlay);
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!(stack.m_41720_() instanceof TurtleItem)) continue;
            return TurtleOverlayRecipe.make(stack, this.overlay);
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<TurtleOverlayRecipe> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE_OVERLAY.get();
    }

    public static class Serializer
    implements RecipeSerializer<TurtleOverlayRecipe> {
        public TurtleOverlayRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapelessRecipeSpec recipe = ShapelessRecipeSpec.fromJson(json);
            ResourceLocation overlay = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"overlay"));
            return new TurtleOverlayRecipe(id, recipe, overlay);
        }

        public TurtleOverlayRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ShapelessRecipeSpec recipe = ShapelessRecipeSpec.fromNetwork(buffer);
            ResourceLocation overlay = buffer.m_130281_();
            return new TurtleOverlayRecipe(id, recipe, overlay);
        }

        public void toNetwork(FriendlyByteBuf buffer, TurtleOverlayRecipe recipe) {
            recipe.toSpec().toNetwork(buffer);
            buffer.m_130085_(recipe.overlay);
        }
    }
}

