/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client.turtle;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public interface TurtleUpgradeModeller<T extends ITurtleUpgrade> {
    public TransformedModel getModel(T var1, @Nullable ITurtleAccess var2, TurtleSide var3);

    default public TransformedModel getModel(T upgrade, CompoundTag data, TurtleSide side) {
        return this.getModel(upgrade, (ITurtleAccess)null, side);
    }

    default public Collection<ResourceLocation> getDependencies() {
        return List.of();
    }

    public static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> flatItem() {
        return TurtleUpgradeModellers.UPGRADE_ITEM;
    }

    public static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> sided(ModelResourceLocation left, ModelResourceLocation right) {
        return TurtleUpgradeModeller.sided((ResourceLocation)left, (ResourceLocation)right);
    }

    public static <T extends ITurtleUpgrade> TurtleUpgradeModeller<T> sided(final ResourceLocation left, final ResourceLocation right) {
        return new TurtleUpgradeModeller<T>(){

            @Override
            public TransformedModel getModel(T upgrade, @Nullable ITurtleAccess turtle, TurtleSide side) {
                return TransformedModel.of(side == TurtleSide.LEFT ? left : right);
            }

            @Override
            public Collection<ResourceLocation> getDependencies() {
                return List.of(left, right);
            }
        };
    }
}

