/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.client.ClientHooks;
import dan200.computercraft.client.ClientRegistry;
import dan200.computercraft.client.sound.SpeakerSound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class ForgeClientHooks {
    private ForgeClientHooks() {
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientHooks.onTick();
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientHooks.onRenderTick();
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            ClientHooks.onWorldUnload();
        }
    }

    @SubscribeEvent
    public static void drawHighlight(RenderHighlightEvent.Block event) {
        if (ClientHooks.drawHighlight(event.getPoseStack(), event.getMultiBufferSource(), event.getCamera(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderText(CustomizeGuiOverlayEvent.DebugText event) {
        ClientHooks.addGameDebugInfo(event.getLeft()::add);
        ClientHooks.addBlockDebugInfo(event.getRight()::add);
    }

    @SubscribeEvent
    public static void onRenderInHand(RenderHandEvent event) {
        if (ClientHooks.onRenderHeldItem(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getHand(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderInFrame(RenderItemInFrameEvent event) {
        if (ClientHooks.onRenderItemFrame(event.getPoseStack(), event.getMultiBufferSource(), event.getItemFrameEntity(), event.getItemStack(), event.getPackedLight())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playStreaming(PlayStreamingSourceEvent event) {
        SpeakerSound sound;
        SoundInstance soundInstance = event.getSound();
        if (!(soundInstance instanceof SpeakerSound) || (sound = (SpeakerSound)soundInstance).getStream() == null) {
            return;
        }
        ClientHooks.onPlayStreaming(event.getEngine(), event.getChannel(), sound.getStream());
    }

    @SubscribeEvent
    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        ClientRegistry.registerClientCommands(event.getDispatcher(), CommandSourceStack::m_81352_);
    }
}

