/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import com.mojang.blaze3d.audio.Channel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import org.lwjgl.BufferUtils;

class DfpwmStream
implements AudioStream {
    private static final int PREC = 10;
    private static final int LPF_STRENGTH = 140;
    private static final AudioFormat MONO_8 = new AudioFormat(48000.0f, 8, 1, true, false);
    private final Queue<ByteBuffer> buffers = new ArrayDeque<ByteBuffer>(2);
    @Nullable
    Channel channel;
    @Nullable
    Executor executor;
    private int charge = 0;
    private int strength = 0;
    private int lowPassCharge;
    private boolean previousBit = false;

    DfpwmStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(ByteBuffer input) {
        int readable = input.remaining();
        ByteBuffer output = ByteBuffer.allocate(readable * 8).order(ByteOrder.nativeOrder());
        for (int i = 0; i < readable; ++i) {
            byte inputByte = input.get();
            for (int j = 0; j < 8; ++j) {
                boolean currentBit = (inputByte & 1) != 0;
                int target = currentBit ? 127 : -128;
                int nextCharge = this.charge + (this.strength * (target - this.charge) + 512 >> 10);
                if (nextCharge == this.charge && nextCharge != target) {
                    nextCharge += currentBit ? 1 : -1;
                }
                int z = currentBit == this.previousBit ? 1023 : 0;
                int nextStrength = this.strength;
                if (this.strength != z) {
                    nextStrength += currentBit == this.previousBit ? 1 : -1;
                }
                if (nextStrength < 8) {
                    nextStrength = 8;
                }
                int chargeWithAntijerk = currentBit == this.previousBit ? nextCharge : nextCharge + this.charge + 1 >> 1;
                this.lowPassCharge += (chargeWithAntijerk - this.lowPassCharge) * 140 + 128 >> 8;
                this.charge = nextCharge;
                this.strength = nextStrength;
                this.previousBit = currentBit;
                output.put((byte)(this.lowPassCharge & 0xFF ^ 0x80));
                inputByte = (byte)(inputByte >> 1);
            }
        }
        output.flip();
        DfpwmStream dfpwmStream = this;
        synchronized (dfpwmStream) {
            this.buffers.add(output);
        }
    }

    public AudioFormat m_6206_() {
        return MONO_8;
    }

    @Nullable
    public synchronized ByteBuffer m_7118_(int capacity) {
        ByteBuffer head;
        ByteBuffer result = BufferUtils.createByteBuffer((int)capacity);
        while (result.hasRemaining() && (head = this.buffers.peek()) != null) {
            int toRead = Math.min(head.remaining(), result.remaining());
            result.put(result.position(), head, head.position(), toRead);
            result.position(result.position() + toRead);
            head.position(head.position() + toRead);
            if (head.hasRemaining()) break;
            this.buffers.remove();
        }
        result.flip();
        return result.remaining() == 0 ? null : result;
    }

    public void close() {
        this.buffers.clear();
    }

    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }
}

