/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import com.mojang.blaze3d.audio.Channel;
import dan200.computercraft.client.sound.DfpwmStream;
import dan200.computercraft.client.sound.SpeakerSound;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;

public class SpeakerInstance {
    public static final ResourceLocation DFPWM_STREAM = new ResourceLocation("computercraft", "speaker.dfpwm_fake_audio_should_not_be_played");
    @Nullable
    private DfpwmStream currentStream;
    @Nullable
    private SpeakerSound sound;

    SpeakerInstance() {
    }

    private void pushAudio(ByteBuffer buffer) {
        SpeakerSound sound = this.sound;
        DfpwmStream stream = this.currentStream;
        if (stream == null) {
            stream = this.currentStream = new DfpwmStream();
        }
        boolean exhausted = stream.isEmpty();
        stream.push(buffer);
        if (exhausted && sound != null && sound.stream == stream && stream.channel != null && stream.executor != null) {
            DfpwmStream actualStream = sound.stream;
            stream.executor.execute(() -> {
                Channel channel = Nullability.assertNonNull(actualStream.channel);
                if (!channel.m_83680_()) {
                    channel.m_83652_(1);
                }
            });
        }
    }

    public void playAudio(SpeakerPosition position, float volume, ByteBuffer buffer) {
        this.pushAudio(buffer);
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (this.sound != null && this.sound.stream != this.currentStream) {
            soundManager.m_120399_((SoundInstance)this.sound);
            this.sound = null;
        }
        if (this.sound != null && !soundManager.m_120403_((SoundInstance)this.sound)) {
            this.sound = null;
        }
        if (this.sound == null && this.currentStream != null) {
            this.sound = new SpeakerSound(DFPWM_STREAM, this.currentStream, position, volume, 1.0f);
            soundManager.m_120367_((SoundInstance)this.sound);
        }
    }

    public void playSound(SpeakerPosition position, ResourceLocation location, float volume, float pitch) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        this.currentStream = null;
        if (this.sound != null) {
            soundManager.m_120399_((SoundInstance)this.sound);
            this.sound = null;
        }
        this.sound = new SpeakerSound(location, null, position, volume, pitch);
        soundManager.m_120367_((SoundInstance)this.sound);
    }

    void setPosition(SpeakerPosition position) {
        if (this.sound != null) {
            this.sound.setPosition(position);
        }
    }

    void stop() {
        if (this.sound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.sound);
        }
        this.currentStream = null;
        this.sound = null;
    }
}

