/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public final class ComputersArgumentType
implements ArgumentType<ComputersSupplier> {
    private static final ComputersArgumentType MANY = new ComputersArgumentType(false);
    private static final ComputersArgumentType SOME = new ComputersArgumentType(true);
    private static final List<String> EXAMPLES = List.of("0", "#0", "@Label", "~Advanced");
    private final boolean requireSome;

    public static ComputersArgumentType manyComputers() {
        return MANY;
    }

    public static ComputersArgumentType someComputers() {
        return SOME;
    }

    public static Collection<ServerComputer> getComputersArgument(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((ComputersSupplier)context.getArgument(name, ComputersSupplier.class)).unwrap((CommandSourceStack)context.getSource());
    }

    private ComputersArgumentType(boolean requireSome) {
        this.requireSome = requireSome;
    }

    public ComputersSupplier parse(StringReader reader) throws CommandSyntaxException {
        ComputersSupplier computers;
        int start = reader.getCursor();
        char kind = reader.peek();
        if (kind == '@') {
            reader.skip();
            String label = reader.readUnquotedString();
            computers = ComputersArgumentType.getComputers(x -> Objects.equals(label, x.getLabel()));
        } else if (kind == '~') {
            reader.skip();
            String family = reader.readUnquotedString();
            computers = ComputersArgumentType.getComputers(x -> x.getFamily().name().equalsIgnoreCase(family));
        } else if (kind == '#') {
            reader.skip();
            int id = reader.readInt();
            computers = ComputersArgumentType.getComputers(x -> x.getID() == id);
        } else {
            int instance = reader.readInt();
            computers = s -> {
                ServerComputer computer = ServerContext.get(s.m_81377_()).registry().get(instance);
                return computer == null ? List.of() : List.of(computer);
            };
        }
        if (this.requireSome) {
            String selector = reader.getString().substring(start, reader.getCursor());
            return source -> {
                Collection<ServerComputer> matched = computers.unwrap(source);
                if (matched.isEmpty()) {
                    throw Exceptions.COMPUTER_ARG_NONE.create((Object)selector);
                }
                return matched;
            };
        }
        return computers;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        if (remaining.startsWith("~")) {
            return CommandUtils.suggest(builder, ComputerFamily.values(), x -> "~" + x.name());
        }
        return CommandUtils.suggestOnServer(context, s -> {
            if (remaining.startsWith("@")) {
                ComputersArgumentType.suggestComputers((CommandSourceStack)s.getSource(), builder, remaining, x -> {
                    String label = x.getLabel();
                    return label == null ? null : "@" + label;
                });
            } else if (remaining.startsWith("#")) {
                ComputersArgumentType.suggestComputers((CommandSourceStack)s.getSource(), builder, remaining, c -> "#" + c.getID());
            } else {
                ComputersArgumentType.suggestComputers((CommandSourceStack)s.getSource(), builder, remaining, c -> Integer.toString(c.getInstanceID()));
            }
            return builder.buildFuture();
        });
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static void suggestComputers(CommandSourceStack source, SuggestionsBuilder builder, String remaining, Function<ServerComputer, String> renderer) {
        remaining = remaining.toLowerCase(Locale.ROOT);
        for (ServerComputer computer : ServerContext.get(source.m_81377_()).registry().getComputers()) {
            String converted = renderer.apply(computer);
            if (converted == null || !converted.toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            builder.suggest(converted);
        }
    }

    private static ComputersSupplier getComputers(Predicate<ServerComputer> predicate) {
        return s -> ServerContext.get(s.m_81377_()).registry().getComputers().stream().filter(predicate).toList();
    }

    public static Set<ServerComputer> unwrap(CommandSourceStack source, Collection<ComputersSupplier> suppliers) throws CommandSyntaxException {
        HashSet<ServerComputer> computers = new HashSet<ServerComputer>();
        for (ComputersSupplier supplier : suppliers) {
            computers.addAll(supplier.unwrap(source));
        }
        return computers;
    }

    @FunctionalInterface
    public static interface ComputersSupplier {
        public Collection<ServerComputer> unwrap(CommandSourceStack var1) throws CommandSyntaxException;
    }

    public record Template(Info info, boolean requireSome) implements ArgumentTypeInfo.Template<ComputersArgumentType>
    {
        public ComputersArgumentType instantiate(CommandBuildContext context) {
            return this.requireSome ? SOME : MANY;
        }

        public Info type() {
            return this.info;
        }
    }

    public static class Info
    implements ArgumentTypeInfo<ComputersArgumentType, Template> {
        public void serializeToNetwork(Template arg, FriendlyByteBuf buf) {
            buf.writeBoolean(arg.requireSome());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buf) {
            boolean requiresSome = buf.readBoolean();
            return new Template(this, requiresSome);
        }

        public void serializeToJson(Template arg, JsonObject json) {
            json.addProperty("requireSome", Boolean.valueOf(arg.requireSome));
        }

        public Template unpack(ComputersArgumentType argumentType) {
            return new Template(this, argumentType.requireSome);
        }
    }
}

