/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class TreasureDiskItem
extends Item
implements IMedia {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_COLOUR = "Colour";
    private static final String NBT_SUB_PATH = "SubPath";

    public TreasureDiskItem(Item.Properties settings) {
        super(settings);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag tooltipOptions) {
        String label = TreasureDiskItem.getTitle(stack);
        if (!label.isEmpty()) {
            list.add((Component)Component.m_237113_((String)label));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public String getLabel(ItemStack stack) {
        return TreasureDiskItem.getTitle(stack);
    }

    @Override
    @Nullable
    public Mount createDataMount(ItemStack stack, ServerLevel level) {
        Mount rootTreasure = ComputerCraftAPI.createResourceMount(level.m_7654_(), "computercraft", "lua/treasure");
        if (rootTreasure == null) {
            return null;
        }
        String subPath = TreasureDiskItem.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ItemStack create(String subPath, int colourIndex) {
        ItemStack result = new ItemStack((ItemLike)ModRegistry.Items.TREASURE_DISK.get());
        CompoundTag nbt = result.m_41784_();
        nbt.m_128359_(NBT_SUB_PATH, subPath);
        int slash = subPath.indexOf(47);
        if (slash >= 0) {
            String author = subPath.substring(0, slash);
            String title = subPath.substring(slash + 1);
            nbt.m_128359_(NBT_TITLE, "\"" + title + "\" by " + author);
        } else {
            nbt.m_128359_(NBT_TITLE, "untitled");
        }
        nbt.m_128405_(NBT_COLOUR, Colour.values()[colourIndex].getHex());
        return result;
    }

    private static String getTitle(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_TITLE) ? nbt.m_128461_(NBT_TITLE) : "'missingno' by how did you get this anyway?";
    }

    private static String getSubPath(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_SUB_PATH) ? nbt.m_128461_(NBT_SUB_PATH) : "dan200/alongtimeago";
    }

    public static int getColour(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_COLOUR) ? nbt.m_128451_(NBT_COLOUR) : Colour.BLUE.getHex();
    }
}

