/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.google.auto.service.AutoService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.FakePlayerExt;
import dan200.computercraft.shared.platform.ForgeConfigFile;
import dan200.computercraft.shared.platform.ForgeContainerTransfer;
import dan200.computercraft.shared.platform.InvalidateCallback;
import dan200.computercraft.shared.platform.NetworkHandler;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

@AutoService(value={dan200.computercraft.impl.PlatformHelper.class})
public class PlatformHelperImpl
implements PlatformHelper {
    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public ConfigFile.Builder createConfigBuilder() {
        return new ForgeConfigFile.Builder();
    }

    @Override
    public <T> ResourceLocation getRegistryKey(ResourceKey<Registry<T>> registry, T object) {
        ResourceLocation key = RegistryManager.ACTIVE.getRegistry(registry).getKey(object);
        if (key == null) {
            throw new IllegalArgumentException(object + " was not registered in " + registry);
        }
        return key;
    }

    @Override
    public <T> T getRegistryObject(ResourceKey<Registry<T>> registry, ResourceLocation id) {
        Object value = RegistryManager.ACTIVE.getRegistry(registry).getValue(id);
        if (value == null) {
            throw new IllegalArgumentException(id + " was not registered in " + registry);
        }
        return (T)value;
    }

    @Override
    public <T> RegistryWrappers.RegistryWrapper<T> wrap(ResourceKey<Registry<T>> key) {
        return new RegistryWrapperImpl(key.m_135782_(), RegistryManager.ACTIVE.getRegistry(key));
    }

    @Override
    public <T> RegistrationHelper<T> createRegistrationHelper(ResourceKey<Registry<T>> registry) {
        return new RegistrationHelperImpl(DeferredRegister.create(registry, (String)"computercraft"));
    }

    @Nullable
    public <K> K tryGetRegistryObject(ResourceKey<Registry<K>> registry, ResourceLocation id) {
        return (K)RegistryManager.ACTIVE.getRegistry(registry).getValue(id);
    }

    @Override
    public boolean shouldLoadResource(JsonObject object) {
        return ICondition.shouldRegisterEntry((JsonElement)object);
    }

    @Override
    public void addRequiredModCondition(JsonObject object, String modId) {
        JsonArray conditions = GsonHelper.m_13832_((JsonObject)object, (String)"forge:conditions", null);
        if (conditions == null) {
            conditions = new JsonArray();
            object.add("forge:conditions", (JsonElement)conditions);
        }
        conditions.add((JsonElement)CraftingHelper.serialize((ICondition)new ModLoadedCondition(modId)));
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> factory, Block block) {
        return new BlockEntityType(factory::apply, Set.of(block), null);
    }

    @Override
    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> I registerArgumentTypeInfo(Class<A> klass, I info) {
        return (I)ArgumentTypeInfos.registerByClass(klass, info);
    }

    @Override
    public <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> createMenuType(Function<FriendlyByteBuf, T> reader, ContainerData.Factory<C, T> factory) {
        return IForgeMenuType.create((id, player, data) -> factory.create(id, player, (ContainerData)reader.apply(data)));
    }

    @Override
    public void openMenu(Player player, MenuProvider owner, ContainerData menu) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)owner, menu::toBytes);
    }

    @Override
    public <T extends NetworkMessage<?>> MessageType<T> createMessageType(int id, ResourceLocation channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        return new NetworkHandler.MessageTypeImpl<T>(id, klass, reader);
    }

    @Override
    public Packet<ClientGamePacketListener> createPacket(NetworkMessage<ClientNetworkContext> message) {
        return NetworkHandler.createClientboundPacket(message);
    }

    @Override
    public ComponentAccess<IPeripheral> createPeripheralAccess(BlockEntity owner, Consumer<Direction> invalidate) {
        return new PeripheralAccess(owner, invalidate);
    }

    @Override
    public ComponentAccess<WiredElement> createWiredElementAccess(BlockEntity owner, Consumer<Direction> invalidate) {
        return new CapabilityAccess<WiredElement>(owner, Capabilities.CAPABILITY_WIRED_ELEMENT, invalidate);
    }

    @Override
    public boolean hasWiredElementIn(Level level, BlockPos pos, Direction direction) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
        return blockEntity != null && blockEntity.getCapability(Capabilities.CAPABILITY_WIRED_ELEMENT, direction.m_122424_()).isPresent();
    }

    @Override
    public ContainerTransfer.Slotted wrapContainer(Container container) {
        return new ForgeContainerTransfer((IItemHandler)new InvWrapper(container));
    }

    @Override
    @Nullable
    public ContainerTransfer getContainer(ServerLevel level, BlockPos pos, Direction side) {
        LazyOptional inventory;
        BlockState block = level.m_8055_(pos);
        Block block2 = block.m_60734_();
        if (block2 instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block2;
            WorldlyContainer container = holder.m_5840_(block, (LevelAccessor)level, pos);
            return new ForgeContainerTransfer((IItemHandler)new SidedInvWrapper(container, side));
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && (inventory = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side)).isPresent()) {
            return new ForgeContainerTransfer((IItemHandler)inventory.orElseThrow(NullPointerException::new));
        }
        Container entity = InventoryUtil.getEntityContainer(level, pos, side);
        return entity == null ? null : new ForgeContainerTransfer((IItemHandler)new InvWrapper(entity));
    }

    @Override
    @Nullable
    public CompoundTag getShareTag(ItemStack item) {
        return item.getShareTag();
    }

    @Override
    public RecipeIngredients getRecipeIngredients() {
        return new RecipeIngredients(Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), Ingredient.m_204132_((TagKey)Tags.Items.STRING), Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), Ingredient.m_204132_((TagKey)Tags.Items.STONE), Ingredient.m_204132_((TagKey)Tags.Items.GLASS_PANES), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.m_204132_((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), Ingredient.m_204132_((TagKey)Tags.Items.HEADS), Ingredient.m_204132_((TagKey)Tags.Items.DYES), Ingredient.m_204132_((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN));
    }

    @Override
    public List<TagKey<Item>> getDyeTags() {
        return List.of(Tags.Items.DYES_WHITE, Tags.Items.DYES_ORANGE, Tags.Items.DYES_MAGENTA, Tags.Items.DYES_LIGHT_BLUE, Tags.Items.DYES_YELLOW, Tags.Items.DYES_LIME, Tags.Items.DYES_PINK, Tags.Items.DYES_GRAY, Tags.Items.DYES_LIGHT_GRAY, Tags.Items.DYES_CYAN, Tags.Items.DYES_PURPLE, Tags.Items.DYES_BLUE, Tags.Items.DYES_BROWN, Tags.Items.DYES_GREEN, Tags.Items.DYES_RED, Tags.Items.DYES_BLACK);
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null);
    }

    @Override
    public CreativeModeTab.Builder newCreativeModeTab() {
        return CreativeModeTab.builder();
    }

    @Override
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.getCraftingRemainingItem();
    }

    @Override
    public List<ItemStack> getRecipeRemainingItems(ServerPlayer player, Recipe<CraftingContainer> recipe, CraftingContainer container) {
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList result = recipe.m_7457_((Container)container);
        ForgeHooks.setCraftingPlayer(null);
        return result;
    }

    @Override
    public void onItemCrafted(ServerPlayer player, CraftingContainer container, ItemStack stack) {
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)stack, (Container)container);
    }

    @Override
    public boolean onNotifyNeighbour(Level level, BlockPos pos, BlockState block, Direction direction) {
        return !ForgeEventFactory.onNeighborNotify((Level)level, (BlockPos)pos, (BlockState)block, EnumSet.of(direction), (boolean)false).isCanceled();
    }

    @Override
    public ServerPlayer createFakePlayer(ServerLevel world, GameProfile profile) {
        return new FakePlayerExt(world, profile);
    }

    @Override
    public double getReachDistance(Player player) {
        return player.getBlockReach();
    }

    @Override
    public boolean hasToolUsage(ItemStack stack) {
        return stack.canPerformAction(ToolActions.SHOVEL_FLATTEN) || stack.canPerformAction(ToolActions.HOE_TILL);
    }

    @Override
    public InteractionResult canAttackEntity(ServerPlayer player, Entity entity) {
        return ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)entity) ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    @Override
    public boolean interactWithEntity(ServerPlayer player, Entity entity, Vec3 hitPos) {
        InteractionResult interactAt = ForgeHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)hitPos, (InteractionHand)InteractionHand.MAIN_HAND);
        if (interactAt == null) {
            interactAt = entity.m_7111_((Player)player, hitPos.m_82546_(entity.m_20182_()), InteractionHand.MAIN_HAND);
        }
        return interactAt.m_19077_() || player.m_36157_(entity, InteractionHand.MAIN_HAND).m_19077_();
    }

    @Override
    public InteractionResult useOn(ServerPlayer player, ItemStack stack, BlockHitResult hit, Predicate<BlockState> canUseBlock) {
        InteractionResult useResult;
        InteractionResult result;
        Level level = player.m_9236_();
        BlockPos pos = hit.m_82425_();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        UseOnContext context = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, hit);
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(context)) != InteractionResult.PASS) {
            return result;
        }
        BlockState block = level.m_8055_(hit.m_82425_());
        if (event.getUseBlock() != Event.Result.DENY && !block.m_60795_() && canUseBlock.test(block) && (useResult = block.m_60664_(level, (Player)player, InteractionHand.MAIN_HAND, hit)).m_19077_()) {
            return useResult;
        }
        return event.getUseItem() == Event.Result.DENY ? InteractionResult.PASS : stack.m_41661_(context);
    }

    private record RegistryWrapperImpl<T>(ResourceLocation name, ForgeRegistry<T> registry) implements RegistryWrappers.RegistryWrapper<T>
    {
        public int m_7447_(T object) {
            return this.registry.getID(object);
        }

        @Override
        public ResourceLocation getKey(T object) {
            ResourceLocation key = this.registry.getKey(object);
            if (key == null) {
                throw new IllegalStateException(object + " was not registered in " + this.name);
            }
            return key;
        }

        @Override
        public T get(ResourceLocation location) {
            Object object = this.registry.getValue(location);
            if (object == null) {
                throw new IllegalStateException(location + " was not registered in " + this.name);
            }
            return (T)object;
        }

        @Override
        @Nullable
        public T tryGet(ResourceLocation location) {
            return (T)this.registry.getValue(location);
        }

        @Nullable
        public T m_7942_(int id) {
            return (T)this.registry.getValue(id);
        }

        public int m_13562_() {
            return this.registry.getKeys().size();
        }

        public Iterator<T> iterator() {
            return this.registry.iterator();
        }
    }

    private record RegistrationHelperImpl<T>(DeferredRegister<T> registry) implements RegistrationHelper<T>
    {
        @Override
        public <U extends T> RegistryEntry<U> register(String name, Supplier<U> create) {
            return new RegistryEntryImpl(this.registry().register(name, create));
        }

        @Override
        public void register() {
            this.registry().register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }

    private static class PeripheralAccess
    extends ComponentAccessImpl<IPeripheral> {
        PeripheralAccess(BlockEntity owner, Consumer<Direction> invalidate) {
            super(owner, invalidate);
        }

        @Override
        @Nullable
        protected IPeripheral get(ServerLevel world, BlockPos pos, Direction side, InvalidateCallback invalidate) {
            return Peripherals.getPeripheral(world, pos, side, invalidate);
        }
    }

    private static class CapabilityAccess<T>
    extends ComponentAccessImpl<T> {
        private final Capability<T> capability;

        CapabilityAccess(BlockEntity owner, Capability<T> capability, Consumer<Direction> invalidate) {
            super(owner, invalidate);
            this.capability = capability;
        }

        @Override
        @Nullable
        protected T get(ServerLevel world, BlockPos pos, Direction side, InvalidateCallback invalidate) {
            if (!world.m_46749_(pos)) {
                return null;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            return blockEntity != null ? (T)CapabilityUtil.unwrap(blockEntity.getCapability(this.capability, side), invalidate) : null;
        }
    }

    private static abstract class ComponentAccessImpl<T>
    implements ComponentAccess<T> {
        private final BlockEntity owner;
        private final InvalidateCallback[] invalidators;

        ComponentAccessImpl(BlockEntity owner, Consumer<Direction> invalidate) {
            this.owner = owner;
            this.invalidators = new InvalidateCallback[6];
            InvalidateCallback[] invalidators = this.invalidators;
            for (Direction dir : Direction.values()) {
                invalidators[dir.ordinal()] = () -> invalidate.accept(dir);
            }
        }

        @Nullable
        protected abstract T get(ServerLevel var1, BlockPos var2, Direction var3, InvalidateCallback var4);

        @Override
        @Nullable
        public T get(Direction direction) {
            return this.get(this.getLevel(), this.owner.m_58899_().m_121945_(direction), direction.m_122424_(), this.invalidators[direction.ordinal()]);
        }

        final ServerLevel getLevel() {
            return Objects.requireNonNull((ServerLevel)this.owner.m_58904_(), "Block entity is not in a level");
        }
    }

    private record RegistryEntryImpl<T>(RegistryObject<T> object) implements RegistryEntry<T>
    {
        @Override
        public ResourceLocation id() {
            return this.object().getId();
        }

        @Override
        public T get() {
            return (T)this.object().get();
        }
    }
}

