/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.compat.rei;

import earth.terrarium.chipped.common.compat.rei.ChippedRecipeCategory;
import earth.terrarium.chipped.common.recipe.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModBlocks;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class REIChippedPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add(new DisplayCategory[]{new ChippedRecipeCategory((Block)ModBlocks.BOTANIST_WORKBENCH.get()), new ChippedRecipeCategory((Block)ModBlocks.GLASSBLOWER.get()), new ChippedRecipeCategory((Block)ModBlocks.CARPENTERS_TABLE.get()), new ChippedRecipeCategory((Block)ModBlocks.LOOM_TABLE.get()), new ChippedRecipeCategory((Block)ModBlocks.MASON_TABLE.get()), new ChippedRecipeCategory((Block)ModBlocks.ALCHEMY_BENCH.get()), new ChippedRecipeCategory((Block)ModBlocks.TINKERING_TABLE.get())});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Minecraft client = Minecraft.m_91087_();
        assert (client.f_91073_ != null);
        RecipeManager recipeManager = client.f_91073_.m_7465_();
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.BOTANIST_WORKBENCH_TYPE.get(), (Block)ModBlocks.BOTANIST_WORKBENCH.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.GLASSBLOWER_TYPE.get(), (Block)ModBlocks.GLASSBLOWER.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.CARPENTERS_TABLE_TYPE.get(), (Block)ModBlocks.CARPENTERS_TABLE.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.LOOM_TABLE_TYPE.get(), (Block)ModBlocks.LOOM_TABLE.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.MASON_TABLE_TYPE.get(), (Block)ModBlocks.MASON_TABLE.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.ALCHEMY_BENCH_TYPE.get(), (Block)ModBlocks.ALCHEMY_BENCH.get());
        this.registerRecipes(recipeManager, registry, ModRecipeTypes.TINKERING_TABLE_TYPE.get(), (Block)ModBlocks.TINKERING_TABLE.get());
    }

    private void registerRecipes(RecipeManager recipeManager, DisplayRegistry registry, RecipeType<ChippedRecipe> type, Block block) {
        ResourceLocation category = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        for (ChippedRecipeCategory.FlattenedRecipe recipe : REIChippedPlugin.flatten(recipeManager.m_44013_(type), (CategoryIdentifier<ChippedRecipeCategory.FlattenedRecipe>)CategoryIdentifier.of((ResourceLocation)category))) {
            registry.add((Display)recipe);
        }
    }

    private static List<ChippedRecipeCategory.FlattenedRecipe> flatten(Collection<ChippedRecipe> recipes, CategoryIdentifier<ChippedRecipeCategory.FlattenedRecipe> category) {
        ArrayList<ChippedRecipeCategory.FlattenedRecipe> flattenedRecipes = new ArrayList<ChippedRecipeCategory.FlattenedRecipe>();
        for (ChippedRecipe recipe : recipes) {
            for (HolderSet<Item> holderSet : recipe.tags()) {
                List<Item> items = holderSet.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).toList();
                Ingredient ingredient = Ingredient.m_43921_(items.stream().map(ItemStack::new));
                for (Item item : items) {
                    flattenedRecipes.add(new ChippedRecipeCategory.FlattenedRecipe(ingredient, new ItemStack((ItemLike)item), category));
                }
            }
        }
        return flattenedRecipes;
    }
}

