/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ResourcePanel
extends PanelBase {
    public static int defaultSide = 0;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0x101010;
    public static int defaultBackgroundColorOut = 13657355;
    public static int defaultBackgroundColorIn = 685776;
    private ResourceLocation icon;
    private String resource = "";
    private IntSupplier curAmt = () -> -1;
    private String curDesc = "";
    private String curUnit = "";
    private IntSupplier maxAmt = () -> -1;
    private String maxDesc = "";
    private String maxUnit = "";
    private DoubleSupplier efficiency = () -> -1.0;

    public ResourcePanel(IGuiAccess gui) {
        this(gui, defaultSide);
    }

    protected ResourcePanel(IGuiAccess gui, int sideIn) {
        super(gui, sideIn);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColorIn;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.setVisible(() -> !this.resource.isEmpty());
    }

    public ResourcePanel setResource(ResourceLocation icon, String resource, boolean producer) {
        this.icon = icon;
        this.resource = resource;
        this.backgroundColor = producer ? defaultBackgroundColorOut : defaultBackgroundColorIn;
        return this;
    }

    public ResourcePanel setCurrent(IntSupplier curAmt, String curDesc, String curUnit) {
        this.curAmt = curAmt;
        this.curDesc = curDesc;
        this.curUnit = curUnit;
        return this;
    }

    public ResourcePanel setMax(IntSupplier maxAmt, String maxDesc, String maxUnit) {
        this.maxAmt = maxAmt;
        this.maxDesc = maxDesc;
        this.maxUnit = maxUnit;
        return this;
    }

    public ResourcePanel setEfficiency(DoubleSupplier efficiency) {
        this.efficiency = efficiency;
        return this;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics) {
        this.drawPanelIcon(pGuiGraphics, this.icon);
        if (!this.fullyOpen) {
            return;
        }
        pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize(this.resource), this.sideOffset() + 20, 6, this.headerColor, true);
        if (this.curAmt.getAsInt() >= 0) {
            pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize(this.curDesc) + ":", this.sideOffset() + 6, 18, this.subheaderColor, true);
            pGuiGraphics.m_280056_(this.fontRenderer(), this.curAmt.getAsInt() + " " + StringHelper.localize(this.curUnit), this.sideOffset() + 14, 30, this.textColor, false);
        }
        if (this.maxAmt.getAsInt() >= 0) {
            pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize(this.maxDesc) + ":", this.sideOffset() + 6, 42, this.subheaderColor, true);
            pGuiGraphics.m_280056_(this.fontRenderer(), this.maxAmt.getAsInt() + " " + StringHelper.localize(this.maxUnit), this.sideOffset() + 14, 54, this.textColor, false);
        }
        if (this.efficiency.getAsDouble() >= 0.0) {
            pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.efficiency") + ":", this.sideOffset() + 6, 66, this.subheaderColor, true);
            pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.DF0.format(this.efficiency.getAsDouble() * 100.0) + "%", this.sideOffset() + 14, 78, this.textColor, false);
        }
        RenderHelper.resetShaderColor();
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add((Component)StringHelper.getTextComponent(this.curAmt.getAsInt() + " " + StringHelper.localize(this.curUnit)));
        }
    }
}

