/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.common.TransientLightManager;
import cofh.core.common.config.CoreClientConfig;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class ArcParticle
extends PointToPointParticle {
    protected final float taper;
    protected Vector3f disp;
    protected LongList path;

    private ArcParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        float dx = (float)(ex - sx);
        float dy = (float)(ey - sy);
        float dz = (float)(ez - sz);
        float dist = MathHelper.dist(dx, dy, dz);
        if (dist < 4.0f) {
            float frac = dist * 0.25f;
            this.taper = frac - 1.25f;
            frac = 1.0f / frac;
            this.disp = new Vector3f(dx * frac, dy * frac, dz * frac);
        } else {
            this.taper = 0.0f;
            this.disp = new Vector3f(dx, dy, dz);
        }
        this.path = this.traversePath();
    }

    public void m_5989_() {
        if (CoreClientConfig.particleDynamicLighting.get().booleanValue() && (float)this.f_107224_ >= this.delay) {
            int light = this.getDynamicLightLevel();
            for (int i = this.path.size() - 1; i >= 0; --i) {
                TransientLightManager.addLight(this.path.getLong(i), light);
            }
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    protected int getDynamicLightLevel() {
        return 8;
    }

    protected LongList traversePath() {
        LongArrayList path = new LongArrayList();
        int i = Mth.m_14107_((double)this.f_107212_);
        int j = Mth.m_14107_((double)this.f_107213_);
        int k = Mth.m_14107_((double)this.f_107214_);
        path.add(BlockPos.m_121882_((int)i, (int)j, (int)k));
        double dx = this.disp.x;
        double dy = this.disp.y;
        double dz = this.disp.z;
        int signX = Mth.m_14205_((double)dx);
        int signY = Mth.m_14205_((double)dy);
        int signZ = Mth.m_14205_((double)dz);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / dx;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / dy;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / dz;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)this.f_107212_) : Mth.m_14185_((double)this.f_107212_));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)this.f_107213_) : Mth.m_14185_((double)this.f_107213_));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)this.f_107214_) : Mth.m_14185_((double)this.f_107214_));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    i += signX;
                    d12 += d9;
                } else {
                    k += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += signY;
                d13 += d10;
            } else {
                k += signZ;
                d14 += d11;
            }
            path.add(BlockPos.m_121882_((int)i, (int)j, (int)k));
        }
        return path;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = time / this.duration;
        float easeCos = MathHelper.cos(progress * (float)Math.PI * 0.5f);
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        VFXHelper.alignVertical(stack, MathHelper.ZERO, this.disp);
        VFXHelper.renderStraightArcs(stack, buffer, packedLight, 2, this.size * (easeCos * 1.5f - 0.5f), 0.015f, VFXHelper.getSeedWithTime(this.seed, this.f_107224_), this.c0.scaleAlpha(easeCub), this.c1.scaleAlpha(easeCub), Math.min(easeCos * -2.5f + 1.25f, this.taper));
    }

    @Override
    public int m_6355_(float pTicks) {
        return 0xF000F0;
    }

    @Override
    public int getLightColor(float pTicks, double x, double y, double z) {
        return 0xF000F0;
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return ArcParticle::new;
    }
}

