/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.ConfigOption;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.config.screen.ConfigurationScreen;
import terrails.colorfulhearts.forge.RenderEventHandler;

public class ColorfulHearts {
    public static ForgeConfigSpec CONFIG_SPEC;
    private static final String CONFIG_FILE = "colorfulhearts.toml";

    static void initialize() {
        ColorfulHearts instance = new ColorfulHearts();
        instance.setupConfig();
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_SPEC, CONFIG_FILE);
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, lastScreen) -> new ConfigurationScreen((Screen)lastScreen)));
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(instance::setup);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    private void setup(FMLClientSetupEvent event) {
        CColorfulHearts.setupCommon();
    }

    private void setupConfig() {
        Object[] configObjects = new Object[]{Configuration.HEALTH, Configuration.ABSORPTION};
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        for (Object object : configObjects) {
            for (Field field : object.getClass().getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object object2 = field.get(object);
                    if (!(object2 instanceof ConfigOption)) continue;
                    ConfigOption option = (ConfigOption)object2;
                    Object t = option.getDefault();
                    if (t instanceof List) {
                        List list = (List)t;
                        String listStr = list.stream().map(Object::toString).collect(Collectors.joining(", "));
                        builder.comment(option.getComment() + "\nDefault: [" + listStr + "]").defineList(option.getPath(), list, option.getOptionValidator());
                        continue;
                    }
                    builder.comment(option.getComment() + "\nDefault: " + option.getDefault().toString()).define(option.getPath(), option.getDefault(), option.getOptionValidator());
                }
                catch (Exception e) {
                    CColorfulHearts.LOGGER.error("Could not process {} in {}", (Object)field.getName(), (Object)configObjects);
                    e.printStackTrace();
                }
            }
        }
        CONFIG_SPEC = builder.build();
        Path path = FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE);
        CColorfulHearts.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autoreload().onFileNotFound(FileNotFoundAction.CREATE_EMPTY).writingMode(WritingMode.REPLACE).build();
        CColorfulHearts.LOGGER.debug("Built TOML config {}", (Object)path);
        config.load();
        CColorfulHearts.LOGGER.debug("Loaded TOML config {}", (Object)path);
        CONFIG_SPEC.setConfig((CommentedConfig)config);
        for (Object object : configObjects) {
            for (Field field : object.getClass().getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object object3 = field.get(object);
                    if (!(object3 instanceof ConfigOption)) continue;
                    ConfigOption option = (ConfigOption)object3;
                    option.initialize(() -> config.get(option.getPath()), val -> config.set(option.getPath(), val));
                }
                catch (Exception e) {
                    CColorfulHearts.LOGGER.error("Could not process {} in {}", (Object)field.getName(), (Object)configObjects);
                    e.printStackTrace();
                }
            }
        }
    }
}

