/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.heart.Heart;
import terrails.colorfulhearts.heart.HeartPiece;
import terrails.colorfulhearts.heart.HeartType;

public class TabHeartRenderer {
    public static final TabHeartRenderer INSTANCE = new TabHeartRenderer();
    private final Minecraft client = Minecraft.m_91087_();
    private Heart[] hearts;
    private int lastHealth;
    private int lastDisplayHealth;

    public void renderPlayerListHud(int y, int x, int offset, PoseStack poseStack, int health, PlayerTabOverlay.HealthState healthState) {
        if (health != this.lastHealth || healthState.m_247739_() != this.lastDisplayHealth || this.hearts == null) {
            int value = Math.max(health, healthState.m_247739_());
            List<HeartPiece> healthColors = HeartPiece.getHeartPiecesForType(HeartType.NORMAL, false);
            List<HeartPiece> absorptionColors = HeartPiece.getHeartPiecesForType(HeartType.NORMAL, true);
            this.hearts = Heart.calculateHearts(0, value, value, healthColors, absorptionColors, false);
            this.lastHealth = health;
            this.lastDisplayHealth = healthState.m_247739_();
            CColorfulHearts.LOGGER.debug("Successfully updated tab hearts.\n{}", (Object)Arrays.toString(this.hearts));
        }
        health = Math.min(health, 20);
        int displayHealth = Math.min(healthState.m_247739_(), 20);
        int displayHealthHearts = Mth.m_14165_((double)((double)displayHealth / 2.0));
        boolean blinking = healthState.m_246447_((long)this.client.f_91065_.m_93079_());
        int spacingDivisor = Math.max(health, displayHealth) / 2;
        int spacingMultiplier = Mth.m_14143_((float)Math.min((float)(offset - x - 4) / (float)spacingDivisor, 9.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
        RenderSystem.enableBlend();
        for (int i = 0; i < this.hearts.length; ++i) {
            Heart heart = this.hearts[i];
            if (heart == null) continue;
            int xPos = x + i % 10 * spacingMultiplier;
            boolean blinkingHeart = blinking && i < displayHealthHearts;
            heart.draw(poseStack, xPos, y, blinking, blinkingHeart, HeartType.NORMAL);
        }
        RenderSystem.disableBlend();
    }
}

