/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.items;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.crafting.RecipeWandUpgrade;
import thetadev.constructionwand.items.core.ItemCoreAngel;
import thetadev.constructionwand.items.core.ItemCoreDestruction;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.items.wand.ItemWandBasic;
import thetadev.constructionwand.items.wand.ItemWandInfinity;

@Mod.EventBusSubscriber(modid="constructionwand", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"constructionwand");
    public static final RegistryObject<Item> WAND_STONE = ITEMS.register("stone_wand", () -> new ItemWandBasic(ModItems.propWand(), (Tier)Tiers.STONE));
    public static final RegistryObject<Item> WAND_IRON = ITEMS.register("iron_wand", () -> new ItemWandBasic(ModItems.propWand(), (Tier)Tiers.IRON));
    public static final RegistryObject<Item> WAND_DIAMOND = ITEMS.register("diamond_wand", () -> new ItemWandBasic(ModItems.propWand(), (Tier)Tiers.DIAMOND));
    public static final RegistryObject<Item> WAND_INFINITY = ITEMS.register("infinity_wand", () -> new ItemWandInfinity(ModItems.propWand()));
    public static final RegistryObject<Item> CORE_ANGEL = ITEMS.register("core_angel", () -> new ItemCoreAngel(ModItems.propUpgrade()));
    public static final RegistryObject<Item> CORE_DESTRUCTION = ITEMS.register("core_destruction", () -> new ItemCoreDestruction(ModItems.propUpgrade()));
    public static final RegistryObject<Item>[] WANDS = new RegistryObject[]{WAND_STONE, WAND_IRON, WAND_DIAMOND, WAND_INFINITY};
    public static final RegistryObject<Item>[] CORES = new RegistryObject[]{CORE_ANGEL, CORE_DESTRUCTION};

    public static Item.Properties propWand() {
        return new Item.Properties();
    }

    private static Item.Properties propUpgrade() {
        return new Item.Properties().m_41487_(1);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, registry -> registry.register("wand_upgrade", RecipeWandUpgrade.SERIALIZER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModelProperties() {
        for (RegistryObject<Item> itemSupplier : WANDS) {
            Item item = (Item)itemSupplier.get();
            ItemProperties.register((Item)item, (ResourceLocation)ConstructionWand.loc("using_core"), (stack, world, entity, n) -> entity == null || !(stack.m_41720_() instanceof ItemWand) ? 0.0f : (((IWandCore)new WandOptions((ItemStack)stack).cores.get()).getColor() > -1 ? 1.0f : 0.0f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        for (RegistryObject<Item> itemSupplier : WANDS) {
            Item item = (Item)itemSupplier.get();
            event.register((stack, layer) -> layer == 1 && stack.m_41720_() instanceof ItemWand ? ((IWandCore)new WandOptions((ItemStack)stack).cores.get()).getColor() : -1, new ItemLike[]{item});
        }
    }

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        block3: {
            block2: {
                if (event.getTabKey() != CreativeModeTabs.f_256869_) break block2;
                for (RegistryObject<Item> itemSupplier : WANDS) {
                    event.accept(itemSupplier);
                }
                break block3;
            }
            if (event.getTabKey() != CreativeModeTabs.f_256968_) break block3;
            for (RegistryObject<Item> itemSupplier : CORES) {
                event.accept(itemSupplier);
            }
        }
    }
}

