/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.Network.NetworkTools;
import com.darkere.crashutils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class RemoveEntitiesMessage {
    ResourceKey<Level> worldRegistryKey;
    ResourceLocation rl;
    ChunkPos pos;
    boolean tile;
    boolean force;

    public RemoveEntitiesMessage(ResourceKey<Level> worldRegistryKey, ResourceLocation rl, ChunkPos pos, boolean tile, boolean force) {
        this.worldRegistryKey = worldRegistryKey;
        this.rl = rl;
        this.pos = pos;
        this.tile = tile;
        this.force = force;
    }

    public static void encode(RemoveEntitiesMessage data, FriendlyByteBuf buf) {
        NetworkTools.writeWorldKey(data.worldRegistryKey, buf);
        buf.m_130085_(data.rl);
        buf.writeBoolean(data.tile);
        buf.writeBoolean(data.force);
        if (data.pos == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(data.pos.m_45588_());
        }
    }

    public static RemoveEntitiesMessage decode(FriendlyByteBuf buf) {
        ResourceKey<Level> world = NetworkTools.readWorldKey(buf);
        ResourceLocation rl = buf.m_130281_();
        boolean tile = buf.readBoolean();
        boolean force = buf.readBoolean();
        ChunkPos pos = null;
        if (buf.readBoolean()) {
            pos = new ChunkPos(buf.readLong());
        }
        return new RemoveEntitiesMessage(world, rl, pos, tile, force);
    }

    public static boolean handle(RemoveEntitiesMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !player.m_20310_(2)) {
                return;
            }
            ServerLevel world = player.m_20194_().m_129880_(data.worldRegistryKey);
            if (data.pos == null) {
                if (data.tile) {
                    WorldUtils.removeTileEntityType((Level)world, data.rl, data.force);
                } else {
                    WorldUtils.removeEntityType((Level)world, data.rl, data.force);
                }
            } else if (data.tile) {
                WorldUtils.removeTileEntitiesInChunk((Level)world, data.pos, data.rl, data.force);
            } else {
                WorldUtils.removeEntitiesInChunk((Level)world, data.pos, data.rl, data.force);
            }
        });
        return true;
    }
}

