/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerRenderer;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeployerActorInstance
extends ActorInstance {
    private final PoseStack stack = new PoseStack();
    Direction facing;
    boolean stationaryTimer;
    float yRot;
    float xRot;
    float zRot;
    ModelData pole;
    ModelData hand;
    RotatingData shaft;

    public DeployerActorInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(materialManager, simulationWorld, context);
        Material mat = materialManager.defaultSolid().material(Materials.TRANSFORMED);
        BlockState state = context.state;
        DeployerBlockEntity.Mode mode = NBTHelper.readEnum(context.blockEntityData, "Mode", DeployerBlockEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        this.stationaryTimer = context.data.m_128441_("StationaryTimer");
        this.facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)state.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.m_122434_() == Direction.Axis.Z;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.xRot = this.facing == Direction.UP ? 270.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f);
        this.zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = (ModelData)mat.getModel(AllPartialModels.DEPLOYER_POLE, state).createInstance();
        this.hand = (ModelData)mat.getModel(handPose, state).createInstance();
        Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
        this.shaft = (RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(KineticBlockEntityInstance.shaft(axis)).createInstance();
        int blockLight = this.localBlockLight();
        this.shaft.setRotationAxis(axis).setPosition(context.localPos).setBlockLight(blockLight);
        this.pole.setBlockLight(blockLight);
        this.hand.setBlockLight(blockLight);
    }

    @Override
    public void beginFrame() {
        double factor;
        if (this.context.disabled) {
            factor = 0.0;
        } else if (this.context.contraption.stalled || this.context.position == null || this.context.data.m_128441_("StationaryTimer")) {
            factor = Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3 center = VecHelper.getCenterOf((Vec3i)BlockPos.m_274446_((Position)this.context.position));
            double distance = this.context.position.m_82554_(center);
            double nextDistance = this.context.position.m_82549_(this.context.motion).m_82554_(center);
            factor = 0.5 - Mth.m_14008_((double)Mth.m_14139_((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3 offset = Vec3.m_82528_((Vec3i)this.facing.m_122436_()).m_82490_(factor);
        TransformStack tstack = TransformStack.cast((PoseStack)this.stack);
        this.stack.m_166856_();
        ((TransformStack)tstack.translate((Vec3i)this.context.localPos)).translate(offset);
        DeployerActorInstance.transformModel(this.stack, this.pole, this.hand, this.yRot, this.xRot, this.zRot);
    }

    static void transformModel(PoseStack stack, ModelData pole, ModelData hand, float yRot, float xRot, float zRot) {
        TransformStack tstack = TransformStack.cast((PoseStack)stack);
        tstack.centre();
        tstack.rotate(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        tstack.rotate(Direction.EAST, (float)((double)(xRot / 180.0f) * Math.PI));
        stack.m_85836_();
        tstack.rotate(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        tstack.unCentre();
        pole.setTransform(stack);
        stack.m_85849_();
        tstack.unCentre();
        hand.setTransform(stack);
    }
}

