/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.stirlingengine;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.newage.content.heat.stirlingengine.StirlingEngineBlockEntity;

public class StirlingEngineInstance
extends KineticBlockEntityInstance<StirlingEngineBlockEntity>
implements DynamicInstance {
    protected final RotatingData shaft;
    protected final ModelData wheel;
    protected float lastAngle = Float.NaN;

    public StirlingEngineInstance(MaterialManager materialManager, StirlingEngineBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.shaft = this.setup((RotatingData)this.getRotatingMaterial().getModel(this.shaft()).createInstance());
        this.wheel = (ModelData)this.getTransformMaterial().getModel((BlockState)AllBlocks.FLYWHEEL.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)((Direction.Axis)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61365_)))).createInstance();
        this.animate(blockEntity.angle);
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float speed = ((StirlingEngineBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((StirlingEngineBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        PoseStack ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        msr.translate((Vec3i)this.getInstancePosition());
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis), AngleHelper.rad((double)angle))).scale(0.2f, 0.2f, 0.2f)).unCentre();
        this.wheel.setTransform(ms);
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.wheel});
    }

    public void remove() {
        this.shaft.delete();
        this.wheel.delete();
    }
}

