/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.network;

import com.tom.createores.CreateOreExcavation;
import com.tom.createores.network.Packet;
import com.tom.createores.network.Packets;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("createoreexcavation", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int id;

    public static void init() {
        Packets.init();
        CreateOreExcavation.LOGGER.info("Initilaized Network Handler");
    }

    public static void handleData(Packet packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> packet.handleClient());
        } else {
            ctx.get().enqueueWork(() -> packet.handleServer(((NetworkEvent.Context)ctx.get()).getSender()));
        }
        ctx.get().setPacketHandled(true);
    }

    public static void sendDataToServer(Packet packet) {
        INSTANCE.sendToServer((Object)packet);
    }

    public static void sendTo(ServerPlayer player, Packet packet) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static <T extends Packet> void register(ResourceLocation rl, Class<T> clazz, Function<FriendlyByteBuf, T> factory) {
        INSTANCE.registerMessage(id++, clazz, Packet::toBytes, factory, NetworkHandler::handleData);
    }
}

