/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.block.CDockBlock;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.item.CDankItem;
import tfar.dankstorage.menu.DockMenu;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.world.CDankSavedData;

public abstract class CommonDockBlockEntity<T extends DankInterface>
extends BlockEntity
implements Nameable,
MenuProvider {
    @javax.annotation.Nullable
    protected Component customName;
    public CompoundTag settings;
    public int numPlayersUsing = 0;
    public static final DankInterface DUMMY = Services.PLATFORM.createInventory(DankStats.zero, -1);

    public CommonDockBlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        super($$0, $$1, $$2);
    }

    public void setFrequency(int freq) {
        if (this.settings != null) {
            this.settings.m_128405_("dankstorage:frequency", freq);
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            this.m_6596_();
            return true;
        }
        return super.m_7531_(id, type);
    }

    @Nullable
    public DockMenu createMenu(int syncId, Inventory inventory, Player player) {
        int tier = (Integer)this.m_58900_().m_61143_((Property)CDockBlock.TIER);
        T dankInventoryForge = this.getInventory();
        DankStats defaults = DankStats.values()[tier];
        if (defaults != dankInventoryForge.getDankStats()) {
            if (defaults.ordinal() < dankInventoryForge.getDankStats().ordinal()) {
                CommonUtils.warn(player, defaults, dankInventoryForge.getDankStats());
                return null;
            }
            dankInventoryForge.upgradeTo(defaults);
        }
        return switch ((Integer)this.m_58900_().m_61143_((Property)CDockBlock.TIER)) {
            case 1 -> DockMenu.t1s(syncId, inventory, dankInventoryForge, this);
            case 2 -> DockMenu.t2s(syncId, inventory, dankInventoryForge, this);
            case 3 -> DockMenu.t3s(syncId, inventory, dankInventoryForge, this);
            case 4 -> DockMenu.t4s(syncId, inventory, dankInventoryForge, this);
            case 5 -> DockMenu.t5s(syncId, inventory, dankInventoryForge, this);
            case 6 -> DockMenu.t6s(syncId, inventory, dankInventoryForge, this);
            case 7 -> DockMenu.t7s(syncId, inventory, dankInventoryForge, this);
            default -> null;
        };
    }

    public T getInventory() {
        if (this.settings != null && this.settings.m_128441_("dankstorage:frequency")) {
            int frequency = this.settings.m_128451_("dankstorage:frequency");
            CDankSavedData savedData = DankStorage.getData(frequency, this.f_58857_.m_7654_());
            DankInterface dataInventory = savedData.createInventory(frequency);
            if (!dataInventory.valid()) {
                savedData.setStats(DankStats.values()[(Integer)this.m_58900_().m_61143_((Property)CDockBlock.TIER)], frequency);
                dataInventory = savedData.createInventory(frequency);
            }
            return (T)dataInventory;
        }
        return (T)DUMMY;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)("container.dankstorage.dank_" + this.m_58900_().m_61143_((Property)CDockBlock.TIER)));
    }

    public int getComparatorSignal() {
        return this.getInventory().calcRedstone();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @javax.annotation.Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component text) {
        this.customName = text;
    }

    @javax.annotation.Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.settings = compound.m_128469_("settings");
        if (compound.m_128425_("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.settings != null) {
            tag.m_128365_("settings", (Tag)this.settings);
        }
        if (this.m_8077_()) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void giveToPlayer(Player player) {
        ItemStack dankInStack = this.removeDankWithoutItemSpawn();
        if (!player.m_36356_(dankInStack)) {
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), dankInStack);
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    public void removeDankWithItemSpawn() {
        ItemStack dankInStack = this.removeDankWithoutItemSpawn();
        ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), dankInStack);
        this.f_58857_.m_7967_((Entity)entity);
    }

    public ItemStack removeDankWithoutItemSpawn() {
        int tier = (Integer)this.m_58900_().m_61143_((Property)CDockBlock.TIER);
        if (tier == 0) {
            throw new RuntimeException("tried to remove a null dank?");
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)CDockBlock.TIER, (Comparable)Integer.valueOf(0)));
        ItemStack stack = new ItemStack((ItemLike)CommonUtils.getItemFromTier(tier));
        if (this.settings != null) {
            stack.m_41784_().m_128365_("settings", (Tag)this.settings);
        }
        this.settings = null;
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        this.setCustomName(null);
        this.m_6596_();
        return stack;
    }

    public void addDank(ItemStack tank) {
        if (tank.m_41720_() instanceof CDankItem) {
            DankStats stats = ((CDankItem)tank.m_41720_()).stats;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)CDockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
            if (tank.m_41788_()) {
                this.setCustomName(tank.m_41786_());
            }
            CompoundTag iSettings = CommonUtils.getSettings(tank);
            tank.m_41774_(1);
            if (iSettings != null && iSettings.m_128441_("dankstorage:frequency")) {
                this.settings = iSettings;
            } else {
                this.settings = new CompoundTag();
                int newId = DankStorage.maxId.getMaxId();
                DankStorage.maxId.increment();
                this.settings.m_128405_("dankstorage:frequency", newId);
            }
            this.m_6596_();
        }
    }

    public void upgradeTo(DankStats stats) {
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)CDockBlock.TIER, (Comparable)Integer.valueOf(stats.ordinal())));
        T dankInventory = this.getInventory();
        dankInventory.upgradeTo(stats);
    }
}

