/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import tfar.dankstorage.network.client.S2CContentsForDisplayPacket;
import tfar.dankstorage.network.client.S2CCustomSyncDataPacket;
import tfar.dankstorage.network.client.S2CSendCustomSlotChangePacket;
import tfar.dankstorage.network.client.S2CSendLockedSlotItemPacket;
import tfar.dankstorage.network.client.S2CSyncSelectedItemPacket;
import tfar.dankstorage.network.server.C2SButtonPacket;
import tfar.dankstorage.network.server.C2SLockSlotPacket;
import tfar.dankstorage.network.server.C2SMessagePickBlock;
import tfar.dankstorage.network.server.C2SRequestContentsPacket;
import tfar.dankstorage.network.server.C2SScrollSlotPacket;
import tfar.dankstorage.network.server.C2SSetFrequencyPacket;
import tfar.dankstorage.network.util.C2SPacketHelper;
import tfar.dankstorage.network.util.S2CPacketHelper;

public class DankPacketHandler {
    public static SimpleChannel INSTANCE;

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dankstorage", "dankstorage"), () -> "1.0", s -> true, s -> true);
        int i = 0;
        INSTANCE.registerMessage(i++, C2SScrollSlotPacket.class, C2SScrollSlotPacket::encode, C2SScrollSlotPacket::new, C2SPacketHelper::handle);
        INSTANCE.registerMessage(i++, C2SLockSlotPacket.class, C2SLockSlotPacket::encode, C2SLockSlotPacket::new, C2SPacketHelper::handle);
        INSTANCE.registerMessage(i++, C2SButtonPacket.class, C2SButtonPacket::encode, C2SButtonPacket::new, C2SPacketHelper::handle);
        INSTANCE.registerMessage(i++, C2SMessagePickBlock.class, C2SMessagePickBlock::encode, C2SMessagePickBlock::new, C2SPacketHelper::handle);
        INSTANCE.registerMessage(i++, C2SSetFrequencyPacket.class, C2SSetFrequencyPacket::encode, C2SSetFrequencyPacket::new, C2SPacketHelper::handle);
        INSTANCE.registerMessage(i++, C2SRequestContentsPacket.class, C2SRequestContentsPacket::encode, C2SRequestContentsPacket::new, C2SPacketHelper::handle);
        INSTANCE.registerMessage(i++, S2CSendCustomSlotChangePacket.class, S2CSendCustomSlotChangePacket::encode, S2CSendCustomSlotChangePacket::new, S2CPacketHelper::handle);
        INSTANCE.registerMessage(i++, S2CSendLockedSlotItemPacket.class, S2CSendLockedSlotItemPacket::encode, S2CSendLockedSlotItemPacket::new, S2CPacketHelper::handle);
        INSTANCE.registerMessage(i++, S2CSyncSelectedItemPacket.class, S2CSyncSelectedItemPacket::encode, S2CSyncSelectedItemPacket::new, S2CPacketHelper::handle);
        INSTANCE.registerMessage(i++, S2CCustomSyncDataPacket.class, S2CCustomSyncDataPacket::encode, S2CCustomSyncDataPacket::new, S2CPacketHelper::handle);
        INSTANCE.registerMessage(i++, S2CContentsForDisplayPacket.class, S2CContentsForDisplayPacket::encode, S2CContentsForDisplayPacket::new, S2CPacketHelper::handle);
    }

    public static void sendCustomSlotChange(ServerPlayer player, int id, int slot, ItemStack stack) {
        DankPacketHandler.sendToClient(new S2CSendCustomSlotChangePacket(id, slot, stack), player);
    }

    public static void sendGhostItemSlot(ServerPlayer player, int id, int slot, ItemStack stack) {
        DankPacketHandler.sendToClient(new S2CSendLockedSlotItemPacket(id, slot, stack), player);
    }

    public static void sendCustomSyncData(ServerPlayer player, int stateID, int containerID, NonNullList<ItemStack> stacks, ItemStack carried) {
        DankPacketHandler.sendToClient(new S2CCustomSyncDataPacket(stateID, containerID, stacks, carried), player);
    }

    public static void sendSelectedItem(ServerPlayer player, ItemStack stack) {
        DankPacketHandler.sendToClient(new S2CSyncSelectedItemPacket(stack), player);
    }

    public static void sendContentsForDisplay(ServerPlayer player, NonNullList<ItemStack> stacks) {
        DankPacketHandler.sendToClient(new S2CContentsForDisplayPacket(stacks), player);
    }

    public static <MSG> void sendToClient(MSG packet, ServerPlayer player) {
        INSTANCE.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void sendToServer(MSG packet) {
        INSTANCE.sendToServer(packet);
    }
}

