/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.client;

import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.client.Client;
import tfar.dankstorage.menu.AbstractDankMenu;
import tfar.dankstorage.network.util.S2CPacketHelper;
import tfar.dankstorage.utils.PacketBufferEX;

public class S2CCustomSyncDataPacket
implements S2CPacketHelper {
    private final int stateID;
    private final int windowId;
    private final NonNullList<ItemStack> stacks;
    private final ItemStack carried;

    public S2CCustomSyncDataPacket(int stateID, int windowId, NonNullList<ItemStack> stacks, ItemStack carried) {
        this.stateID = stateID;
        this.windowId = windowId;
        this.stacks = stacks;
        this.carried = carried;
    }

    public S2CCustomSyncDataPacket(FriendlyByteBuf buf) {
        this.stateID = buf.readInt();
        this.windowId = buf.readInt();
        this.carried = buf.m_130267_();
        int i = buf.readShort();
        this.stacks = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
        for (int j = 0; j < i; ++j) {
            this.stacks.set(j, (Object)PacketBufferEX.readExtendedItemStack(buf));
        }
    }

    @Override
    public void handleClient() {
        Player player = Client.getLocalPlayer();
        if (player != null && player.f_36096_ instanceof AbstractDankMenu && this.windowId == player.f_36096_.f_38840_) {
            player.f_36096_.m_182410_(this.stateID, this.stacks, this.carried);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.stateID);
        buf.writeInt(this.windowId);
        buf.m_130055_(this.carried);
        buf.writeShort(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            PacketBufferEX.writeExtendedItemStack(buf, stack);
        }
    }
}

