/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.inventory.DankInterface;
import tfar.dankstorage.item.CDankItem;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.PickupMode;

public class CommonEvents {
    public static boolean interceptItem(Inventory inv, ItemStack incoming) {
        Player player = inv.f_35978_;
        if (player.m_9236_().f_46443_ || incoming.m_41619_()) {
            return false;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack possibleDank = inv.m_8020_(i);
            if (!(possibleDank.m_41720_() instanceof CDankItem) || !CommonEvents.onItemPickup(player, incoming, possibleDank)) continue;
            return true;
        }
        return false;
    }

    public static boolean onItemPickup(Player player, ItemStack pickup, ItemStack dank) {
        int i;
        PickupMode pickupMode = CommonUtils.getPickupMode(dank);
        if (pickupMode == PickupMode.none) {
            return false;
        }
        DankInterface inv = CommonUtils.getBagInventory(dank, player.m_9236_());
        if (inv == null) {
            DankStorage.LOG.warn("That's odd, the player somehow got an unassigned dank to change pickup mode");
            return false;
        }
        int count = pickup.m_41613_();
        boolean oredict = CommonUtils.oredict(dank);
        ArrayList<ItemStack> existing = new ArrayList<ItemStack>();
        for (i = 0; i < inv.getContainerSizeDank(); ++i) {
            ItemStack stack = inv.getItemDank(i);
            if (stack.m_41619_()) continue;
            boolean exists = false;
            for (ItemStack stack1 : existing) {
                if (!CommonEvents.areItemStacksCompatible(stack, stack1, oredict)) continue;
                exists = true;
            }
            if (exists) continue;
            existing.add(stack.m_41777_());
        }
        block0 : switch (pickupMode) {
            case pickup_all: {
                for (i = 0; i < inv.getContainerSizeDank(); ++i) {
                    CommonEvents.allPickup(inv, i, pickup, oredict);
                    if (pickup.m_41619_()) break block0;
                }
                break;
            }
            case filtered_pickup: {
                for (i = 0; i < inv.getContainerSizeDank(); ++i) {
                    CommonEvents.filteredPickup(inv, i, pickup, oredict, existing);
                    if (pickup.m_41619_()) break block0;
                }
                break;
            }
            case void_pickup: {
                for (i = 0; i < inv.getContainerSizeDank(); ++i) {
                    CommonEvents.voidPickup(inv, i, pickup, oredict, existing);
                    if (pickup.m_41619_()) break block0;
                }
                break;
            }
        }
        if (pickup.m_41613_() != count) {
            dank.m_41754_(5);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
        return pickup.m_41619_();
    }

    public static void voidPickup(DankInterface inv, int slot, ItemStack toInsert, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getItemDank(slot);
        if (CommonEvents.doesItemStackExist(toInsert, filter, oredict) && CommonEvents.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.getDankStats().stacklimit;
            int total = Math.min(toInsert.m_41613_() + existing.m_41613_(), stackLimit);
            inv.setItemDank(slot, CommonUtils.copyStackWithSize(existing, total));
            toInsert.m_41764_(0);
        }
    }

    public static void allPickup(DankInterface inv, int slot, ItemStack pickup, boolean oredict) {
        ItemStack existing = inv.getItemDank(slot);
        if (existing.m_41619_()) {
            int stackLimit = inv.getDankStats().stacklimit;
            int total = pickup.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, pickup.m_41777_());
                pickup.m_41764_(0);
            } else {
                inv.setItemDank(slot, CommonUtils.copyStackWithSize(pickup, stackLimit));
                pickup.m_41764_(remainder);
            }
            return;
        }
        if (ItemStack.m_150942_((ItemStack)pickup, (ItemStack)existing) || oredict) {
            int stackLimit = inv.getDankStats().stacklimit;
            int total = pickup.m_41613_() + existing.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, CommonUtils.copyStackWithSize(existing, total));
                pickup.m_41764_(0);
            } else {
                inv.setItemDank(slot, CommonUtils.copyStackWithSize(pickup, stackLimit));
                pickup.m_41764_(remainder);
            }
        }
    }

    public static void filteredPickup(DankInterface inv, int slot, ItemStack toInsert, boolean oredict, List<ItemStack> filter) {
        ItemStack existing = inv.getItemDank(slot);
        if (existing.m_41619_() && CommonEvents.doesItemStackExist(toInsert, filter, oredict)) {
            int stackLimit = inv.getDankStats().stacklimit;
            int total = toInsert.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, toInsert.m_41777_());
                toInsert.m_41764_(0);
            } else {
                inv.setItemDank(slot, CommonUtils.copyStackWithSize(toInsert, stackLimit));
                toInsert.m_41764_(remainder);
            }
            return;
        }
        if (CommonEvents.doesItemStackExist(toInsert, filter, oredict) && CommonEvents.areItemStacksCompatible(existing, toInsert, oredict)) {
            int stackLimit = inv.getDankStats().stacklimit;
            int total = toInsert.m_41613_() + existing.m_41613_();
            int remainder = total - stackLimit;
            if (remainder <= 0) {
                inv.setItemDank(slot, CommonUtils.copyStackWithSize(existing, total));
                toInsert.m_41764_(0);
            } else {
                inv.setItemDank(slot, CommonUtils.copyStackWithSize(toInsert, stackLimit));
                toInsert.m_41764_(remainder);
            }
        }
    }

    public static boolean areItemStacksCompatible(ItemStack stackA, ItemStack stackB, boolean oredict) {
        return oredict ? ItemStack.m_150942_((ItemStack)stackA, (ItemStack)stackB) && ItemStack.m_41656_((ItemStack)stackA, (ItemStack)stackB) : ItemStack.m_150942_((ItemStack)stackA, (ItemStack)stackB) && ItemStack.m_41656_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean doesItemStackExist(ItemStack stack, List<ItemStack> filter, boolean oredict) {
        for (ItemStack filterStack : filter) {
            if (!CommonEvents.areItemStacksCompatible(stack, filterStack, oredict)) continue;
            return true;
        }
        return false;
    }
}

