/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.network.server;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import tfar.dankstorage.item.CDankItem;
import tfar.dankstorage.network.PacketIds;
import tfar.dankstorage.network.server.C2SModPacket;
import tfar.dankstorage.platform.Services;
import tfar.dankstorage.utils.CommonUtils;
import tfar.dankstorage.utils.KeybindAction;

public class C2SButtonPacket
implements C2SModPacket {
    private final KeybindAction keybindAction;

    public C2SButtonPacket(KeybindAction keybindAction) {
        this.keybindAction = keybindAction;
    }

    public C2SButtonPacket(FriendlyByteBuf buf) {
        this.keybindAction = KeybindAction.values()[buf.readInt()];
    }

    public static void send(KeybindAction keybindAction) {
        Services.PLATFORM.sendToServer(new C2SButtonPacket(keybindAction), PacketIds.button_action);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        switch (this.keybindAction) {
            case TOGGLE_PICKUP: {
                CommonUtils.togglePickupMode(player);
                break;
            }
            case TOGGLE_USE_TYPE: {
                CommonUtils.toggleUseType(player);
                break;
            }
            case PICK_BLOCK: {
                ItemStack pick;
                HitResult hit = player.m_19907_(5.0, 0.0f, false);
                if (!(hit instanceof BlockHitResult)) break;
                BlockHitResult blockHit = (BlockHitResult)hit;
                if (hit.m_6662_() == HitResult.Type.MISS || (pick = Services.PLATFORM.getCloneStack(player.m_9236_(), blockHit.m_82425_(), player.m_9236_().m_8055_(blockHit.m_82425_()), hit, (Player)player)).m_41619_()) break;
                if (player.m_21205_().m_41720_() instanceof CDankItem) {
                    CommonUtils.setPickSlot(player.m_9236_(), player.m_21205_(), pick);
                    break;
                }
                if (!(player.m_21206_().m_41720_() instanceof CDankItem)) break;
                CommonUtils.setPickSlot(player.m_9236_(), player.m_21206_(), pick);
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.keybindAction.ordinal());
    }
}

