/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.items;

import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.util.DDTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.RegistryObject;

public class SculkTransmitterItem
extends Item {
    public SculkTransmitterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (pContext.m_43722_().m_41782_()) {
            return this.transmit(pContext.m_43725_(), pContext.m_43723_(), pContext.m_43724_(), pContext.m_8083_());
        }
        if (!this.canConnect(pContext.m_43725_(), pContext.m_8083_())) {
            this.actionBarMessage(pContext.m_43723_(), "not_transmittable", DDSounds.TRANSMITTER_ERROR);
            return InteractionResult.FAIL;
        }
        this.actionBarMessage(pContext.m_43723_(), "linked", DDSounds.TRANSMITTER_LINK);
        this.formConnection(pContext.m_43722_(), pContext.m_8083_());
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.m_21205_().m_41782_()) {
            this.transmit(pLevel, pPlayer, pUsedHand, null);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (pStack.m_41782_()) {
            int[] pos = pStack.m_41783_().m_128465_("blockPos");
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltips.deeperdarker.sculk_transmitter.linked", (Object[])new Object[]{pLevel.m_8055_(new BlockPos(pos[0], pos[1], pos[2])).m_60734_().m_49954_()}).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltips.deeperdarker.sculk_transmitter.location", (Object[])new Object[]{pos[0], pos[1], pos[2]}).m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltips.deeperdarker.sculk_transmitter.not_linked").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private InteractionResult transmit(Level level, Player player, InteractionHand hand, BlockPos clickedPos) {
        int[] pos = player.m_21205_().m_41783_().m_128465_("blockPos");
        BlockPos linkedBlockPos = new BlockPos(pos[0], pos[1], pos[2]);
        ItemStack transmitter = player.m_21120_(hand);
        if (player.m_6047_()) {
            if (clickedPos != null && this.canConnect(level, clickedPos)) {
                this.actionBarMessage(player, "linked", DDSounds.TRANSMITTER_LINK);
                this.formConnection(transmitter, clickedPos);
                return InteractionResult.SUCCESS;
            }
            this.actionBarMessage(player, "unlinked", DDSounds.TRANSMITTER_UNLINK);
            this.formConnection(transmitter, null);
            return InteractionResult.FAIL;
        }
        if (!this.canConnect(level, linkedBlockPos)) {
            this.actionBarMessage(player, "not_found", DDSounds.TRANSMITTER_ERROR);
            this.formConnection(transmitter, null);
            return InteractionResult.FAIL;
        }
        level.m_220407_(GameEvent.f_223708_, player.m_20183_(), GameEvent.Context.m_223717_((Entity)player));
        MenuProvider menu = level.m_8055_(linkedBlockPos).m_60750_(level, linkedBlockPos);
        if (menu != null) {
            player.m_5496_((SoundEvent)DDSounds.TRANSMITTER_OPEN.get(), 1.0f, 1.0f);
            player.m_5893_(menu);
            BlockEntity blockEntity = level.m_7702_(linkedBlockPos);
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                chestBlockEntity.m_5856_(player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void formConnection(ItemStack stack, BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        if (pos == null) {
            stack.m_41749_("blockPos");
            return;
        }
        tag.m_128408_("blockPos", List.of(Integer.valueOf(pos.m_123341_()), Integer.valueOf(pos.m_123342_()), Integer.valueOf(pos.m_123343_())));
        stack.m_41751_(tag);
    }

    private boolean canConnect(Level level, BlockPos target) {
        return level.m_8055_(target).m_204336_(DDTags.Blocks.TRANSMITTABLE);
    }

    private void actionBarMessage(Player player, String key, RegistryObject<SoundEvent> sound) {
        player.m_5661_((Component)Component.m_237115_((String)("block.deeperdarker." + key)), true);
        player.m_216990_((SoundEvent)sound.get());
    }
}

