/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.core.block;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.deepresonance.compat.DeepResonanceTOPDriver;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.radiation.manager.DRRadiationManager;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ExplosionTools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ResonatingCrystalBlock
extends BaseBlock {
    private static final VoxelShape AABB = Shapes.m_83048_((double)0.1f, (double)0.0, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f);
    private final boolean generated;
    private final boolean empty;

    public ResonatingCrystalBlock(boolean generated, boolean empty) {
        super(new BlockBuilder().topDriver((TOPDriver)DeepResonanceTOPDriver.DRIVER).properties(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60955_()).tileEntitySupplier(ResonatingCrystalTileEntity::new));
        this.generated = generated;
        this.empty = empty;
    }

    public ResonatingCrystalBlock getEmpty() {
        if (this.generated) {
            return (ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED_EMPTY.get());
        }
        return (ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_NATURAL_EMPTY.get());
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return AABB;
    }

    public RotationType getRotationType() {
        return RotationType.HORIZROTATION;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof ResonatingCrystalTileEntity) {
            return this.createStack((ResonatingCrystalTileEntity)tile);
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack createStack(ResonatingCrystalTileEntity crystal) {
        ItemStack ret = new ItemStack((ItemLike)this);
        ret.m_41700_("BlockEntityTag", (Tag)crystal.m_187482_());
        return ret;
    }

    public List<ItemStack> getItemsForTab() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ResonatingCrystalTileEntity crystal = new ResonatingCrystalTileEntity(BlockPos.f_121853_, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.get())).m_49966_());
        for (int power : new int[]{0, 50}) {
            for (int purity : new int[]{0, 50}) {
                ItemStack stack = new ItemStack((ItemLike)this);
                crystal.setPurity(purity);
                crystal.setPower(power);
                stack.m_41700_("BlockEntityTag", (Tag)crystal.m_187482_());
                items.add(stack);
            }
        }
        return items;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.f_46443_) {
            ResonatingCrystalBlock.explode(world, pos);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    private static void explodeHelper(Level world, BlockPos location, float radius) {
        Explosion boom = ExplosionTools.explodeFullDestroy((Level)world, (BlockPos)location, (float)radius);
        int x = (int)(-radius);
        while ((float)x < radius) {
            int y = (int)(-radius);
            while ((float)y < radius) {
                int z = (int)(-radius);
                while ((float)z < radius) {
                    BlockPos targetPosition = location.m_7918_(x, y, z);
                    double dist = Math.sqrt(location.m_123331_((Vec3i)targetPosition));
                    if (dist < (double)radius) {
                        BlockState state = world.m_8055_(targetPosition);
                        Block block = state.m_60734_();
                        float resistance = state.getExplosionResistance((BlockGetter)world, targetPosition, boom);
                        if (!state.m_60795_() && resistance > 0.0f && (dist < (double)(radius - 1.0f) || (double)world.f_46441_.m_188501_() > 0.7)) {
                            block.onBlockExploded(state, world, targetPosition, boom);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void explode(Level world, BlockPos pos) {
        BlockEntity theCrystalTile = world.m_7702_(pos);
        world.m_7654_().m_6937_((Runnable)new TickTask((int)(world.m_46467_() + 1L), () -> {
            double forceMultiplier = 1.0;
            if (theCrystalTile instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)theCrystalTile;
                float explosionStrength = (float)(crystal.getPower() * crystal.getStrength() / 10000.0);
                forceMultiplier = (double)explosionStrength * ((Double)RadiationConfiguration.MAXIMUM_EXPLOSION_MULTIPLIER.get() - (Double)RadiationConfiguration.MINIMUM_EXPLOSION_MULTIPLIER.get()) + (Double)RadiationConfiguration.MINIMUM_EXPLOSION_MULTIPLIER.get();
                if (forceMultiplier > (Double)RadiationConfiguration.ABSOLUTE_MAXIMUM_EXPLOSION_MULTIPLIER.get()) {
                    forceMultiplier = (Double)RadiationConfiguration.ABSOLUTE_MAXIMUM_EXPLOSION_MULTIPLIER.get();
                }
                if (forceMultiplier > (double)0.001f) {
                    DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
                    DRRadiationManager.RadiationSource source = radiationManager.getOrCreateRadiationSource(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
                    double radiationRadius = DRRadiationManager.calculateRadiationRadius(crystal.getStrength(), crystal.getEfficiency(), crystal.getPurity());
                    double radiationStrength = DRRadiationManager.calculateRadiationStrength(crystal.getStrength(), crystal.getPurity());
                    source.update((float)(radiationRadius * (Double)RadiationConfiguration.RADIATION_EXPLOSION_FACTOR.get()), (float)(radiationStrength / (Double)RadiationConfiguration.RADIATION_EXPLOSION_FACTOR.get()), 1000);
                }
            }
            if (forceMultiplier > (double)0.001f) {
                ResonatingCrystalBlock.explodeHelper(world, pos, (float)forceMultiplier);
            }
        }));
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag advanced) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            tagCompound = tagCompound.m_128469_("BlockEntityTag").m_128469_("Info");
        }
        super.m_5871_(stack, world, tooltip, advanced);
        float power = 100.0f;
        if (tagCompound != null) {
            power = tagCompound.m_128457_("power");
        }
        if (power > 1.0E-5f) {
            tooltip.add((Component)ComponentFactory.translatable((String)"message.deepresonance.crystal_power"));
        } else {
            tooltip.add((Component)ComponentFactory.translatable((String)"message.deepresonance.crystal_empty"));
        }
        if (tagCompound != null) {
            ResonatingCrystalBlock.addBasicInformation(tooltip::add, tagCompound, power, true);
        }
    }

    public static void addBasicInformation(Consumer<Component> tooltip, CompoundTag tag, float power, boolean showPower) {
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        tooltip.accept((Component)ComponentFactory.translatable((String)"message.deepresonance.crystal_sep").m_130940_(ChatFormatting.GREEN).m_130946_(": " + decimalFormat.format(tag.m_128457_("strength")) + "% " + decimalFormat.format(tag.m_128457_("efficiency")) + "% " + decimalFormat.format(tag.m_128457_("purity")) + "%"));
        if (showPower) {
            tooltip.accept((Component)ComponentFactory.literal((String)("Power left: " + decimalFormat.format(power) + "%")).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

