/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.block;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.block.EnergyCollectorTileEntity;
import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.data.DRGeneratorNetwork;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.sound.GeneratorSoundController;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GeneratorControllerTileEntity
extends TickingTileEntity {
    private int startup = 0;
    private int shutdown = 0;
    private boolean active = false;
    private PlayingSound clientSound = PlayingSound.NONE;

    public GeneratorControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GeneratorModule.TYPE_GENERATOR_CONTROLLER.get(), pos, state);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        boolean working = this.isPowered();
        super.onDataPacket(net, packet);
        if (this.f_58857_.f_46443_ && this.isPowered() != working) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_) {
            this.stopSounds();
        }
    }

    protected void tickServer() {
        PlayingSound newsound;
        boolean active1 = this.powerLevel > 0;
        boolean dirty = false;
        HashSet<Integer> networks = new HashSet<Integer>();
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            GeneratorPartTileEntity generatorTileEntity;
            int networkId;
            BlockPos newC = this.m_58899_().m_121945_(direction);
            Block b = this.f_58857_.m_8055_(newC).m_60734_();
            if (b != GeneratorModule.GENERATOR_PART_BLOCK.get() || (networkId = (generatorTileEntity = (GeneratorPartTileEntity)this.f_58857_.m_7702_(newC)).getMultiblockId()) == -1 || networks.contains(networkId)) continue;
            networks.add(networkId);
            if (active1) {
                int countCollectors = this.getCollectorBlocks(generatorTileEntity.getMultiblockId(), generatorTileEntity.getBlob(), newC);
                if (countCollectors == 1) {
                    if (!this.handleActivate(networkId, newC)) continue;
                    dirty = true;
                    continue;
                }
                if (countCollectors < 1) {
                    Broadcaster.broadcast((Level)this.f_58857_, (int)this.m_58899_().m_123341_(), (int)this.m_58899_().m_123342_(), (int)this.m_58899_().m_123343_(), (String)"There is no energy collector on this generator!", (float)100.0f);
                } else {
                    Broadcaster.broadcast((Level)this.f_58857_, (int)this.m_58899_().m_123341_(), (int)this.m_58899_().m_123342_(), (int)this.m_58899_().m_123343_(), (String)"There are too many energy collectors on this generator!!", (float)100.0f);
                }
                if (!this.handleDeactivate(networkId, newC)) continue;
                dirty = true;
                continue;
            }
            if (!this.handleDeactivate(networkId, newC)) continue;
            dirty = true;
        }
        if (networks.isEmpty()) {
            this.shutdown = 0;
        }
        if (dirty) {
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.f_58857_);
            generatorNetwork.save();
        }
        if ((newsound = this.getPlayingSound()) != this.clientSound) {
            this.clientSound = newsound;
            this.markDirtyClient();
        }
    }

    protected void tickClient() {
        if ((Double)GeneratorConfig.BASE_GENERATOR_VOLUME.get() < (double)0.01f) {
            return;
        }
        switch (this.clientSound) {
            case NONE: {
                this.stopSounds();
                break;
            }
            case STARTUP: {
                if (GeneratorSoundController.isStartupPlaying(this.f_58857_, this.f_58858_)) break;
                GeneratorSoundController.playStartup(this.f_58857_, this.f_58858_);
                break;
            }
            case ACTIVE: {
                if (GeneratorSoundController.isLoopPlaying(this.f_58857_, this.f_58858_)) break;
                GeneratorSoundController.playLoop(this.f_58857_, this.f_58858_);
                break;
            }
            case SHUTDOWN: {
                if (GeneratorSoundController.isShutdownPlaying(this.f_58857_, this.f_58858_)) break;
                GeneratorSoundController.playShutdown(this.f_58857_, this.f_58858_);
            }
        }
    }

    private PlayingSound getPlayingSound() {
        if (this.startup != 0) {
            return PlayingSound.STARTUP;
        }
        if (this.shutdown != 0) {
            return PlayingSound.SHUTDOWN;
        }
        if (this.active) {
            return PlayingSound.ACTIVE;
        }
        return PlayingSound.NONE;
    }

    private void stopSounds() {
        GeneratorSoundController.stopSound(this.f_58857_, this.m_58899_());
    }

    private MultiblockDriver<GeneratorBlob> getDriver() {
        return DRGeneratorNetwork.getNetwork(this.f_58857_).getDriver();
    }

    private int getCollectorBlocks(int id, GeneratorBlob network, BlockPos p) {
        if (network.getCollectorBlocks() <= 0) {
            Set positions = MultiblockSupport.findMultiblock((Level)this.f_58857_, (BlockPos)p, this.getDriver());
            int cnt = 0;
            for (BlockPos pos : positions) {
                if (!(this.f_58857_.m_7702_(pos.m_7494_()) instanceof EnergyCollectorTileEntity)) continue;
                ++cnt;
            }
            int finalCnt = cnt;
            this.getDriver().modify(id, holder -> ((GeneratorBlob)holder.getMb()).setCollectorBlocks(finalCnt));
        }
        return network.getCollectorBlocks();
    }

    private boolean handleActivate(int id, BlockPos coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.f_58857_);
        GeneratorBlob network = generatorNetwork.getOrCreateBlob(id);
        if (network.isActive() && network.getShutdownCounter() == 0) {
            return false;
        }
        this.startup = network.getStartupCounter();
        if (this.startup == 0) {
            this.startup = (Integer)GeneratorConfig.STARTUP_TIME.get();
        }
        --this.startup;
        if (this.startup <= 0) {
            this.startup = 0;
            GeneratorPartTileEntity generatorTileEntity = (GeneratorPartTileEntity)this.f_58857_.m_7702_(coordinate);
            generatorTileEntity.activate(true);
        }
        this.active = network.isActive();
        this.shutdown = 0;
        network.setShutdownCounter(0);
        network.setStartupCounter(this.startup);
        this.m_6596_();
        return true;
    }

    private boolean handleDeactivate(int id, BlockPos coordinate) {
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getNetwork(this.f_58857_);
        GeneratorBlob network = generatorNetwork.getOrCreateBlob(id);
        if (!network.isActive() && network.getShutdownCounter() == 0 && network.getStartupCounter() == 0) {
            if (network.getShutdownCounter() != this.shutdown || network.getStartupCounter() != this.startup || network.isActive() != this.active) {
                this.shutdown = network.getShutdownCounter();
                this.startup = network.getStartupCounter();
                this.active = network.isActive();
                this.m_6596_();
            }
            return false;
        }
        this.shutdown = network.getShutdownCounter();
        if (network.isActive() || network.getStartupCounter() != 0) {
            this.shutdown = (Integer)GeneratorConfig.SHUTDOWN_TIME.get();
            GeneratorPartTileEntity generatorTileEntity = (GeneratorPartTileEntity)this.f_58857_.m_7702_(coordinate);
            generatorTileEntity.activate(false);
        }
        --this.shutdown;
        if (this.shutdown <= 0) {
            this.shutdown = 0;
        }
        this.startup = 0;
        this.active = network.isActive();
        network.setStartupCounter(0);
        network.setShutdownCounter(this.shutdown);
        this.m_6596_();
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.m_6596_();
        }
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("startup", this.startup);
        tagCompound.m_128405_("shutdown", this.shutdown);
        tagCompound.m_128379_("active", this.active);
        tagCompound.m_128405_("playingSound", this.clientSound.ordinal());
        super.m_183515_(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        this.startup = tagCompound.m_128451_("startup");
        this.shutdown = tagCompound.m_128451_("shutdown");
        this.active = tagCompound.m_128471_("active");
        this.clientSound = PlayingSound.values()[tagCompound.m_128451_("playingSound")];
        super.m_142466_(tagCompound);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128405_("playingSound", this.clientSound.ordinal());
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.clientSound = PlayingSound.values()[tagCompound.m_128451_("playingSound")];
    }

    static enum PlayingSound {
        NONE,
        STARTUP,
        ACTIVE,
        SHUTDOWN;

    }
}

