/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.client;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.block.LaserTileEntity;
import mcjty.deepresonance.modules.machines.data.InfusingBonus;
import mcjty.deepresonance.modules.machines.util.config.LaserConfig;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class LaserGui
extends GenericGuiContainer<LaserTileEntity, GenericContainer> {
    public static final int LASER_WIDTH = 180;
    public static final int LASER_HEIGHT = 152;
    private EnergyBar energyBar;
    private EnergyBar crystalBar;
    private Label purifyBonus;
    private Label strengthBonus;
    private Label efficiencyBonus;
    private static final ResourceLocation GUI = new ResourceLocation("deepresonance", "textures/gui/laser.png");

    public LaserGui(LaserTileEntity tileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)tileEntity, (AbstractContainerMenu)container, inventory, ManualEntry.EMPTY);
        this.f_97726_ = 180;
        this.f_97727_ = 152;
    }

    public void m_7856_() {
        super.m_7856_();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue((long)((LaserTileEntity)this.tileEntity).getMaxPower()).hint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 59))).showText(false).value((long)((LaserTileEntity)this.tileEntity).getCurrentPower());
        this.crystalBar = ((EnergyBar)new EnergyBar().vertical().maxValue((long)((Integer)LaserConfig.CRYSTAL_LIQUID_MAXIMUM.get()).intValue()).hint((LayoutHint)new PositionalLayout.PositionalHint(153, 7, 19, 38))).showText(false).setEnergyOnColor(-16750849).setEnergyOffColor(-16764058).setSpacerColor(-16772830).value(0L);
        this.purifyBonus = (Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 100, 14));
        this.strengthBonus = (Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint((LayoutHint)new PositionalLayout.PositionalHint(5, 23, 100, 14));
        this.efficiencyBonus = (Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint((LayoutHint)new PositionalLayout.PositionalHint(5, 41, 100, 14));
        Panel catalystPanel = (Panel)((Panel)((Panel)((Panel)new Panel().layout((Layout)new PositionalLayout()).hint((LayoutHint)new PositionalLayout.PositionalHint(41, 7, 109, 59))).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{this.purifyBonus, this.strengthBonus, this.efficiencyBonus});
        Panel toplevel = (Panel)((Panel)new Panel().background(GUI)).layout((Layout)new PositionalLayout()).children(new Widget[]{this.energyBar, catalystPanel, this.crystalBar});
        toplevel.setBounds(new Rectangle(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        Slot slot = ((GenericContainer)this.f_97732_).m_38853_(1);
        if (slot.m_6657_()) {
            InfusingBonus bonus = LaserTileEntity.getInfusingBonus(slot.m_7993_());
            if (bonus != null) {
                this.setBonusText(bonus.purityModifier(), "P", this.purifyBonus);
                this.setBonusText(bonus.strengthModifier(), "S", this.strengthBonus);
                this.setBonusText(bonus.efficiencyModifier(), "E", this.efficiencyBonus);
            } else {
                this.purifyBonus.text("Not a catalyst!");
                this.strengthBonus.text("");
                this.efficiencyBonus.text("");
            }
        } else {
            this.purifyBonus.text("Catalyst missing!");
            this.strengthBonus.text("");
            this.efficiencyBonus.text("");
        }
        this.crystalBar.value((long)((int)((LaserTileEntity)this.tileEntity).getCrystalLiquid()));
        this.updateEnergyBar(this.energyBar);
        super.m_7286_(graphics, partialTicks, x, y);
    }

    private void setBonusText(InfusingBonus.Modifier modifier, String prefix, Label label) {
        if (Math.abs(modifier.bonus()) > 0.01f) {
            label.text(prefix + ": " + this.formatted(modifier.bonus()) + "% (cap " + this.formatted(modifier.maxOrMin()) + ")");
        } else {
            label.text(prefix + ": none");
        }
    }

    private String formatted(float f) {
        return new DecimalFormat("##.#").format(f);
    }

    public static void register() {
        LaserGui.register((MenuType)((MenuType)MachinesModule.LASER_CONTAINER.get()), LaserGui::new);
    }
}

