/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.PostBlock;
import com.ldtteam.domumornamentum.block.types.PostType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class PostBlockItem
extends BlockItem
implements IDoItem {
    private final PostBlock postBlock;

    public PostBlockItem(PostBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.postBlock = blockIn;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.postBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.m_237110_((String)"domum_ornamentum.post.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        PostType postType;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        try {
            postType = stack.m_41784_().m_128441_("type") ? PostType.valueOf(stack.m_41784_().m_128461_("type").toUpperCase()) : PostType.PLAIN;
        }
        catch (Exception ex) {
            postType = PostType.PLAIN;
        }
        tooltip.add((Component)Component.m_237115_((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.post.type.format", (Object[])new Object[]{Component.m_237115_((String)("domum_ornamentum.post.type.name." + postType.getTranslationKeySuffix()))}));
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent postComponent = (IMateriallyTexturedBlockComponent)this.postBlock.getComponents().get(0);
        Block postBlock = textureData.getTexturedComponents().getOrDefault(postComponent.getId(), postComponent.getDefault());
        Component postBlockName = BlockUtils.getHoverName(postBlock);
        tooltip.add((Component)Component.m_237110_((String)"domum_ornamentum.desc.onlyone", (Object[])new Object[]{Component.m_237110_((String)"domum_ornamentum.desc.material", (Object[])new Object[]{postBlockName})}));
    }

    @Override
    public ResourceLocation getGroup() {
        return new ResourceLocation("domum_ornamentum", "kpost");
    }
}

