/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.deity;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.util.KnowledgeUtil;
import elucent.eidolon.util.RGBProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public abstract class Deity
implements RGBProvider {
    protected final ResourceLocation id;
    final int red;
    final int green;
    final int blue;
    protected final Progression progression;

    public Progression getProgression() {
        return this.progression;
    }

    public Deity(ResourceLocation id, int red, int green, int blue) {
        this.id = id;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.progression = new Progression(new Stage(Eidolon.prefix("start"), 0, true));
    }

    @Override
    public float getRed() {
        return (float)this.red / 255.0f;
    }

    @Override
    public float getGreen() {
        return (float)this.green / 255.0f;
    }

    @Override
    public float getBlue() {
        return (float)this.blue / 255.0f;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void onReputationChange(Player player, IReputation rep, double prev, double updated) {
        double curr;
        Stage nextStage = this.progression.tryProgress(rep, player, prev, updated);
        Stage currStage = this.progression.next(prev);
        if (nextStage == null) {
            rep.setReputation(player.m_20148_(), this.id, (double)this.progression.max);
            return;
        }
        if (nextStage.rep > currStage.rep) {
            this.onReputationUnlock(player, rep, currStage.id());
        }
        if ((curr = rep.getReputation(player, this.getId())) == (double)nextStage.rep() && updated != curr) {
            this.onReputationLock(player, rep, currStage.id());
        }
    }

    public abstract void onReputationUnlock(Player var1, IReputation var2, ResourceLocation var3);

    public abstract void onReputationLock(Player var1, IReputation var2, ResourceLocation var3);

    public class Progression {
        final TreeMap<Integer, Stage> steps = new TreeMap();
        public int max;

        public void setMax(int max) {
            this.steps.put(max, new Stage(Eidolon.prefix("end"), max, true));
            this.max = max;
        }

        public Progression(Stage ... stages) {
            for (Stage s : stages) {
                this.steps.put(s.rep, s);
            }
            this.max = this.steps.lastKey();
        }

        public Progression add(Stage stage) {
            this.steps.put(stage.rep, stage);
            this.max = this.steps.lastKey();
            return this;
        }

        public Stage next(double rep) {
            return this.steps.ceilingEntry(Mth.m_14045_((int)((int)(rep + 0.5)), (int)0, (int)this.max)).getValue();
        }

        public Stage last(double rep) {
            return this.steps.floorEntry((int)rep).getValue();
        }

        public Stage prev(double rep) {
            return this.steps.floorEntry(this.steps.floorKey((int)Math.max(rep - 0.5, 0.0))).getValue();
        }

        public Stage tryProgress(IReputation rep, Player player, double prev, double current) {
            if (current >= (double)this.max) {
                return null;
            }
            Stage s = this.next(prev);
            if (current > (double)s.rep) {
                if (s.satisfiedBy(player)) {
                    return this.next(current);
                }
                rep.setReputation(player.m_20148_(), Deity.this.getId(), (double)s.rep);
            }
            return s;
        }

        public void regress(IReputation rep, Player player) {
            double level = rep.getReputation(player, Deity.this.getId());
            Stage s = this.prev(level);
            rep.setReputation(player, Deity.this.getId(), Math.min(level, (double)s.rep));
        }
    }

    public record Stage(ResourceLocation id, int rep, boolean major, List<StageRequirement> reqs) {
        public Stage(ResourceLocation id, int rep, boolean major) {
            this(id, rep, major, new ArrayList<StageRequirement>());
        }

        public Stage requirement(StageRequirement req) {
            this.reqs.add(req);
            return this;
        }

        boolean satisfiedBy(Player player) {
            boolean satisfied = true;
            for (StageRequirement req : this.reqs) {
                if (req.isMet(player)) continue;
                satisfied = false;
                break;
            }
            return satisfied;
        }
    }

    public static class SignRequirement
    implements StageRequirement {
        final Sign sign;

        public SignRequirement(Sign sign) {
            this.sign = sign;
        }

        @Override
        public boolean isMet(Player player) {
            return KnowledgeUtil.knowsSign(player, this.sign);
        }
    }

    public static class ResearchRequirement
    implements StageRequirement {
        final ResourceLocation r;

        public ResearchRequirement(Research r) {
            this.r = r.getRegistryName();
        }

        public ResearchRequirement(ResourceLocation r) {
            this.r = r;
        }

        @Override
        public boolean isMet(Player player) {
            return KnowledgeUtil.knowsResearch(player, this.r);
        }
    }

    public static interface StageRequirement {
        public boolean isMet(Player var1);
    }
}

