/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.api.ritual;

import elucent.eidolon.api.ritual.IRequirement;
import elucent.eidolon.api.ritual.IRitualItemProvider;
import elucent.eidolon.api.ritual.RequirementInfo;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.crafting.PartialNBTIngredient;

public class ItemRequirement
implements IRequirement {
    final Ingredient match;

    public ItemRequirement(Ingredient item) {
        this.match = item;
    }

    public ItemRequirement(ItemStack item) {
        this.match = item.m_41782_() ? PartialNBTIngredient.of((ItemLike)item.m_41720_(), (CompoundTag)item.m_41784_()) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{item});
    }

    public ItemRequirement(Item item) {
        this.match = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    public ItemRequirement(Block block) {
        this.match = Ingredient.m_43929_((ItemLike[])new ItemLike[]{block});
    }

    public ItemRequirement(TagKey<Item> item) {
        this.match = Ingredient.m_204132_(item);
    }

    @Override
    public RequirementInfo isMet(Ritual ritual, Level world, BlockPos pos) {
        List<IRitualItemProvider> tiles = Ritual.getTilesWithinAABB(IRitualItemProvider.class, world, ritual.getSearchBounds(pos));
        if (tiles.isEmpty()) {
            return RequirementInfo.FALSE;
        }
        for (IRitualItemProvider tile : tiles) {
            ItemStack stack = tile.provide();
            if (!this.match.test(stack)) continue;
            return new RequirementInfo(true, ((BlockEntity)tile).m_58899_());
        }
        return RequirementInfo.FALSE;
    }

    @Override
    public void whenMet(Ritual ritual, Level world, BlockPos pos, RequirementInfo info) {
        ((IRitualItemProvider)world.m_7702_(info.getPos())).take();
        if (!world.f_46443_) {
            Networking.sendToTracking(world, pos.m_6630_(2), new RitualConsumePacket(info.getPos(), pos.m_6630_(2), ritual.getRed(), ritual.getGreen(), ritual.getBlue()));
        }
    }

    public Ingredient getMatch() {
        return this.match;
    }
}

