/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import elucent.eidolon.common.entity.RavenEntity;
import elucent.eidolon.event.ClientEvents;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RavenModel
extends EntityModel<RavenEntity> {
    private final ModelPart body;

    public RavenModel(ModelPart root) {
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-0.5f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -3.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 6).m_171488_(-0.5f, -2.0f, -5.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-1.5f));
        PartDefinition wings = body.m_171599_("wings", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-2.0f, -3.5f, -0.5f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid = body.m_171599_("tailMid", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftTail = body.m_171599_("leftTail", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition rightTail = body.m_171599_("rightTail", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.75f, (float)-3.0f, (float)2.5f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftWing = body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition rightWing = body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171480_().m_171488_(-10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)-5.5f, (float)-1.5f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(12, 7).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(12, 7).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-3.0f, (float)0.5f));
        PartDefinition chest = body.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(1, 6).m_171488_(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderOnShoulder(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float p_228284_5_, float p_228284_6_, float p_228284_7_, float p_228284_8_, int p_228284_9_) {
        this.body.m_171324_((String)"leftWing").f_104207_ = false;
        this.body.m_171324_((String)"rightWing").f_104207_ = false;
        this.body.m_171324_((String)"wings").f_104207_ = true;
        this.body.m_104301_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(RavenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart leftWing = this.body.m_171324_("leftWing");
        ModelPart rightWing = this.body.m_171324_("rightWing");
        ModelPart wings = this.body.m_171324_("wings");
        ModelPart rightLeg = this.body.m_171324_("rightLeg");
        ModelPart leftLeg = this.body.m_171324_("leftLeg");
        ModelPart head = this.body.m_171324_("head");
        this.body.f_104201_ = 24.0f;
        if (entity.m_20096_() || !entity.isAddedToWorld()) {
            leftWing.f_104207_ = false;
            rightWing.f_104207_ = false;
            wings.f_104207_ = true;
            if (entity.m_21824_() && entity.m_21825_()) {
                rightLeg.f_104203_ = -1.0471976f;
                leftLeg.f_104203_ = -1.0471976f;
                this.body.f_104201_ = 25.5f;
            } else {
                rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
            }
        } else {
            leftWing.f_104207_ = true;
            rightWing.f_104207_ = true;
            wings.f_104207_ = false;
            rightLeg.f_104203_ = 0.0f;
            leftLeg.f_104203_ = 0.0f;
            if (entity.m_20184_().f_82480_ < 0.0) {
                rightWing.f_104205_ = Mth.m_14031_((float)ClientEvents.getClientTicks()) * 0.1f;
                leftWing.f_104205_ = -Mth.m_14031_((float)(0.97f + ClientEvents.getClientTicks())) * 0.1f;
            } else {
                rightWing.f_104205_ = (float)Math.sin(ClientEvents.getClientTicks()) * 0.4f;
                leftWing.f_104205_ = -((float)Math.sin(ClientEvents.getClientTicks())) * 0.4f;
            }
        }
        head.f_104203_ = (float)Math.toRadians(headPitch);
        head.f_104204_ = (float)Math.toRadians(netHeadYaw);
    }

    public void m_7695_(@NotNull PoseStack matrixStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

